/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.date.culture.en;

import java.time.temporal.ChronoField;
import org.miaixz.bus.core.center.date.culture.en.Month;
import org.miaixz.bus.core.lang.Assert;

public enum Quarter {
    Q1(1, "\u4e00\u5b63\u5ea6"),
    Q2(2, "\u4e8c\u5b63\u5ea6"),
    Q3(3, "\u4e09\u5b63\u5ea6"),
    Q4(4, "\u56db\u5b63\u5ea6");

    private static final Quarter[] ENUMS;
    private final int code;
    private final String name;

    private Quarter(int code, String name) {
        this.code = code;
        this.name = name;
    }

    public static Quarter of(int intValue) {
        switch (intValue) {
            case 1: {
                return Q1;
            }
            case 2: {
                return Q2;
            }
            case 3: {
                return Q3;
            }
            case 4: {
                return Q4;
            }
        }
        return null;
    }

    public static String getName(int code) {
        return Quarter.ENUMS[code].name;
    }

    public int getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public static Quarter fromMonth(int monthValue) {
        ChronoField.MONTH_OF_YEAR.checkValidValue(monthValue);
        return Quarter.of(Quarter.computeQuarterValueInternal(monthValue));
    }

    public static Quarter fromMonth(Month month) {
        Assert.notNull(month);
        int monthValue = month.getValue();
        return Quarter.of(Quarter.computeQuarterValueInternal(monthValue));
    }

    public Month firstMonth() {
        return Month.of(this.code * 3 - 3);
    }

    public Month lastMonth() {
        return Month.of(this.code * 3 - 1);
    }

    private static int computeQuarterValueInternal(int monthValue) {
        return (monthValue - 1) / 3 + 1;
    }

    static {
        ENUMS = Quarter.values();
    }
}

