/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.date.culture.lunar;

import java.util.List;
import org.miaixz.bus.core.center.date.culture.Loops;
import org.miaixz.bus.core.center.date.culture.cn.Taboo;
import org.miaixz.bus.core.center.date.culture.cn.eightchar.EightChar;
import org.miaixz.bus.core.center.date.culture.cn.eightchar.provider.EightCharProvider;
import org.miaixz.bus.core.center.date.culture.cn.eightchar.provider.impl.DefaultEightCharProvider;
import org.miaixz.bus.core.center.date.culture.cn.ren.MinorRen;
import org.miaixz.bus.core.center.date.culture.cn.sixty.EarthBranch;
import org.miaixz.bus.core.center.date.culture.cn.sixty.HeavenStem;
import org.miaixz.bus.core.center.date.culture.cn.sixty.SixtyCycle;
import org.miaixz.bus.core.center.date.culture.cn.sixty.SixtyCycleHour;
import org.miaixz.bus.core.center.date.culture.cn.star.nine.NineStar;
import org.miaixz.bus.core.center.date.culture.cn.star.twelve.TwelveStar;
import org.miaixz.bus.core.center.date.culture.lunar.LunarDay;
import org.miaixz.bus.core.center.date.culture.solar.SolarDay;
import org.miaixz.bus.core.center.date.culture.solar.SolarTerms;
import org.miaixz.bus.core.center.date.culture.solar.SolarTime;

public class LunarHour
extends Loops {
    public static EightCharProvider provider = new DefaultEightCharProvider();
    protected LunarDay day;
    protected int hour;
    protected int minute;
    protected int second;
    protected SolarTime solarTime;
    protected SixtyCycleHour sixtyCycleHour;

    public LunarHour(int year, int month, int day, int hour, int minute, int second) {
        if (hour < 0 || hour > 23) {
            throw new IllegalArgumentException(String.format("illegal hour: %d", hour));
        }
        if (minute < 0 || minute > 59) {
            throw new IllegalArgumentException(String.format("illegal minute: %d", minute));
        }
        if (second < 0 || second > 59) {
            throw new IllegalArgumentException(String.format("illegal second: %d", second));
        }
        this.day = LunarDay.fromYmd(year, month, day);
        this.hour = hour;
        this.minute = minute;
        this.second = second;
    }

    public static LunarHour fromYmdHms(int year, int month, int day, int hour, int minute, int second) {
        return new LunarHour(year, month, day, hour, minute, second);
    }

    public LunarDay getLunarDay() {
        return this.day;
    }

    public int getYear() {
        return this.day.getYear();
    }

    public int getMonth() {
        return this.day.getMonth();
    }

    public int getDay() {
        return this.day.getDay();
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getSecond() {
        return this.second;
    }

    @Override
    public String getName() {
        return EarthBranch.fromIndex(this.getIndexInDay()).getName() + "\u65f6";
    }

    @Override
    public String toString() {
        return String.valueOf(this.day) + this.getSixtyCycle().getName() + "\u65f6";
    }

    public int getIndexInDay() {
        return (this.hour + 1) / 2;
    }

    @Override
    public LunarHour next(int n) {
        if (n == 0) {
            return LunarHour.fromYmdHms(this.getYear(), this.getMonth(), this.getDay(), this.hour, this.minute, this.second);
        }
        int h = this.hour + n * 2;
        int diff = h < 0 ? -1 : 1;
        int hour = Math.abs(h);
        int days = hour / 24 * diff;
        if ((hour = hour % 24 * diff) < 0) {
            hour += 24;
            --days;
        }
        LunarDay d = this.day.next(days);
        return LunarHour.fromYmdHms(d.getYear(), d.getMonth(), d.getDay(), hour, this.minute, this.second);
    }

    public boolean isBefore(LunarHour target) {
        if (!this.day.equals(target.getLunarDay())) {
            return this.day.isBefore(target.getLunarDay());
        }
        if (this.hour != target.getHour()) {
            return this.hour < target.getHour();
        }
        return this.minute != target.getMinute() ? this.minute < target.getMinute() : this.second < target.getSecond();
    }

    public boolean isAfter(LunarHour target) {
        if (!this.day.equals(target.getLunarDay())) {
            return this.day.isAfter(target.getLunarDay());
        }
        if (this.hour != target.getHour()) {
            return this.hour > target.getHour();
        }
        return this.minute != target.getMinute() ? this.minute > target.getMinute() : this.second > target.getSecond();
    }

    public SixtyCycle getSixtyCycle() {
        int earthBranchIndex = this.getIndexInDay() % 12;
        SixtyCycle d = this.day.getSixtyCycle();
        if (this.hour >= 23) {
            d = d.next(1);
        }
        int heavenStemIndex = d.getHeavenStem().getIndex() % 5 * 2 + earthBranchIndex;
        return SixtyCycle.fromName(HeavenStem.fromIndex(heavenStemIndex).getName() + EarthBranch.fromIndex(earthBranchIndex).getName());
    }

    public TwelveStar getTwelveStar() {
        return TwelveStar.fromIndex(this.getSixtyCycle().getEarthBranch().getIndex() + (8 - this.getSixtyCycleHour().getDay().getEarthBranch().getIndex() % 6) * 2);
    }

    public NineStar getNineStar() {
        SolarDay solar = this.day.getSolarDay();
        SolarTerms dongZhi = SolarTerms.fromIndex(solar.getYear(), 0);
        SolarTerms xiaZhi = dongZhi.next(12);
        boolean asc = !solar.isBefore(dongZhi.getJulianDay().getSolarDay()) && solar.isBefore(xiaZhi.getJulianDay().getSolarDay());
        int start = (new int[]{8, 5, 2})[this.day.getSixtyCycle().getEarthBranch().getIndex() % 3];
        if (asc) {
            start = 8 - start;
        }
        int earthBranchIndex = this.getIndexInDay() % 12;
        return NineStar.fromIndex(start + (asc ? earthBranchIndex : -earthBranchIndex));
    }

    public SolarTime getSolarTime() {
        if (null == this.solarTime) {
            SolarDay d = this.day.getSolarDay();
            this.solarTime = SolarTime.fromYmdHms(d.getYear(), d.getMonth(), d.getDay(), this.hour, this.minute, this.second);
        }
        return this.solarTime;
    }

    public EightChar getEightChar() {
        return provider.getEightChar(this);
    }

    public SixtyCycleHour getSixtyCycleHour() {
        if (null == this.sixtyCycleHour) {
            this.sixtyCycleHour = this.getSolarTime().getSixtyCycleHour();
        }
        return this.sixtyCycleHour;
    }

    public List<Taboo> getRecommends() {
        return Taboo.getHourRecommends(this.getSixtyCycleHour().getDay(), this.getSixtyCycle());
    }

    public List<Taboo> getAvoids() {
        return Taboo.getHourAvoids(this.getSixtyCycleHour().getDay(), this.getSixtyCycle());
    }

    public MinorRen getMinorRen() {
        return this.getLunarDay().getMinorRen().next(this.getIndexInDay());
    }
}

