/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.date.culture.solar;

import java.util.ArrayList;
import java.util.List;
import org.miaixz.bus.core.center.date.culture.Loops;
import org.miaixz.bus.core.center.date.culture.en.Quarter;
import org.miaixz.bus.core.center.date.culture.solar.SolarMonth;
import org.miaixz.bus.core.center.date.culture.solar.SolarYear;

public class SolarQuarter
extends Loops {
    protected SolarYear year;
    protected int index;

    public SolarQuarter(int year, int index) {
        if (index < 0 || index > 3) {
            throw new IllegalArgumentException(String.format("illegal solar season index: %d", index));
        }
        this.year = SolarYear.fromYear(year);
        this.index = index;
    }

    public static SolarQuarter fromIndex(int year, int index) {
        return new SolarQuarter(year, index);
    }

    public SolarYear getSolarYear() {
        return this.year;
    }

    public int getYear() {
        return this.year.getYear();
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public String getName() {
        return Quarter.getName(this.index);
    }

    @Override
    public String toString() {
        return String.valueOf(this.year) + this.getName();
    }

    @Override
    public SolarQuarter next(int n) {
        int i = this.index + n;
        return SolarQuarter.fromIndex((this.getYear() * 4 + i) / 4, this.indexOf(i, 4));
    }

    public List<SolarMonth> getMonths() {
        ArrayList<SolarMonth> l = new ArrayList<SolarMonth>(3);
        int y = this.getYear();
        for (int i = 1; i < 4; ++i) {
            l.add(SolarMonth.fromYm(y, this.index * 3 + i));
        }
        return l;
    }
}

