/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.date.culture.solar;

import java.util.ArrayList;
import java.util.List;
import org.miaixz.bus.core.center.date.culture.Loops;
import org.miaixz.bus.core.center.date.culture.rabjung.RabjungYear;
import org.miaixz.bus.core.center.date.culture.solar.SolarHalfYear;
import org.miaixz.bus.core.center.date.culture.solar.SolarMonth;
import org.miaixz.bus.core.center.date.culture.solar.SolarQuarter;

public class SolarYear
extends Loops {
    protected int year;

    public SolarYear(int year) {
        if (year < 1 || year > 9999) {
            throw new IllegalArgumentException(String.format("illegal solar year: %d", year));
        }
        this.year = year;
    }

    public static SolarYear fromYear(int year) {
        return new SolarYear(year);
    }

    public int getYear() {
        return this.year;
    }

    public int getDayCount() {
        if (1582 == this.year) {
            return 355;
        }
        return this.isLeap() ? 366 : 365;
    }

    public boolean isLeap() {
        if (this.year < 1600) {
            return this.year % 4 == 0;
        }
        return this.year % 4 == 0 && this.year % 100 != 0 || this.year % 400 == 0;
    }

    @Override
    public String getName() {
        return String.format("%d\u5e74", this.year);
    }

    @Override
    public SolarYear next(int n) {
        return SolarYear.fromYear(this.year + n);
    }

    public List<SolarMonth> getMonths() {
        ArrayList<SolarMonth> l = new ArrayList<SolarMonth>(12);
        for (int i = 1; i < 13; ++i) {
            l.add(SolarMonth.fromYm(this.year, i));
        }
        return l;
    }

    public List<SolarQuarter> getSeasons() {
        ArrayList<SolarQuarter> l = new ArrayList<SolarQuarter>(4);
        for (int i = 0; i < 4; ++i) {
            l.add(SolarQuarter.fromIndex(this.year, i));
        }
        return l;
    }

    public List<SolarHalfYear> getHalfYears() {
        ArrayList<SolarHalfYear> l = new ArrayList<SolarHalfYear>(2);
        for (int i = 0; i < 2; ++i) {
            l.add(SolarHalfYear.fromIndex(this.year, i));
        }
        return l;
    }

    public RabjungYear getRabByungYear() {
        return RabjungYear.fromYear(this.year);
    }
}

