/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.date.format;

import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.miaixz.bus.core.center.date.format.FormatCache;
import org.miaixz.bus.core.center.date.format.parser.FastDateParser;
import org.miaixz.bus.core.center.date.format.parser.PositionDateParser;
import org.miaixz.bus.core.center.date.printer.FastDatePrinter;
import org.miaixz.bus.core.center.date.printer.FormatPrinter;
import org.miaixz.bus.core.lang.exception.DateException;

public class FormatBuilder
extends Format
implements PositionDateParser,
FormatPrinter {
    private static final long serialVersionUID = 2852255307380L;
    private static final FormatCache<FormatBuilder> CACHE = new FormatCache<FormatBuilder>(){

        @Override
        protected FormatBuilder createInstance(String pattern, TimeZone timeZone, Locale locale) {
            return new FormatBuilder(pattern, timeZone, locale);
        }
    };
    private final FastDatePrinter printer;
    private final FastDateParser parser;

    protected FormatBuilder(String pattern, TimeZone timeZone, Locale locale) {
        this(pattern, timeZone, locale, null);
    }

    protected FormatBuilder(String pattern, TimeZone timeZone, Locale locale, Date centuryStart) {
        this.printer = new FastDatePrinter(pattern, timeZone, locale);
        this.parser = new FastDateParser(pattern, timeZone, locale, centuryStart);
    }

    public static FormatBuilder getInstance() {
        return CACHE.getInstance();
    }

    public static FormatBuilder getInstance(String pattern) {
        return CACHE.getInstance(pattern, null, null);
    }

    public static FormatBuilder getInstance(String pattern, TimeZone timeZone) {
        return CACHE.getInstance(pattern, timeZone, null);
    }

    public static FormatBuilder getInstance(String pattern, Locale locale) {
        return CACHE.getInstance(pattern, null, locale);
    }

    public static FormatBuilder getInstance(String pattern, TimeZone timeZone, Locale locale) {
        return CACHE.getInstance(pattern, timeZone, locale);
    }

    public static FormatBuilder getDateInstance(int style) {
        return CACHE.getDateInstance(style, null, null);
    }

    public static FormatBuilder getDateInstance(int style, Locale locale) {
        return CACHE.getDateInstance(style, null, locale);
    }

    public static FormatBuilder getDateInstance(int style, TimeZone timeZone) {
        return CACHE.getDateInstance(style, timeZone, null);
    }

    public static FormatBuilder getDateInstance(int style, TimeZone timeZone, Locale locale) {
        return CACHE.getDateInstance(style, timeZone, locale);
    }

    public static FormatBuilder getTimeInstance(int style) {
        return CACHE.getTimeInstance(style, null, null);
    }

    public static FormatBuilder getTimeInstance(int style, Locale locale) {
        return CACHE.getTimeInstance(style, null, locale);
    }

    public static FormatBuilder getTimeInstance(int style, TimeZone timeZone) {
        return CACHE.getTimeInstance(style, timeZone, null);
    }

    public static FormatBuilder getTimeInstance(int style, TimeZone timeZone, Locale locale) {
        return CACHE.getTimeInstance(style, timeZone, locale);
    }

    public static FormatBuilder getDateTimeInstance(int dateStyle, int timeStyle) {
        return CACHE.getDateTimeInstance(dateStyle, timeStyle, null, null);
    }

    public static FormatBuilder getDateTimeInstance(int dateStyle, int timeStyle, Locale locale) {
        return CACHE.getDateTimeInstance(dateStyle, timeStyle, null, locale);
    }

    public static FormatBuilder getDateTimeInstance(int dateStyle, int timeStyle, TimeZone timeZone) {
        return FormatBuilder.getDateTimeInstance(dateStyle, timeStyle, timeZone, null);
    }

    public static FormatBuilder getDateTimeInstance(int dateStyle, int timeStyle, TimeZone timeZone, Locale locale) {
        return CACHE.getDateTimeInstance(dateStyle, timeStyle, timeZone, locale);
    }

    public static DateTimeFormatter getDateTimeInstance(String pattern) {
        return DateTimeFormatter.ofPattern(pattern, Locale.getDefault()).withZone(ZoneId.systemDefault());
    }

    @Override
    public StringBuffer format(Object object, StringBuffer toAppendTo, FieldPosition pos) {
        return toAppendTo.append(this.printer.format(object));
    }

    @Override
    public String format(long millis) {
        return this.printer.format(millis);
    }

    @Override
    public String format(Date date) {
        return this.printer.format(date);
    }

    @Override
    public String format(Calendar calendar) {
        return this.printer.format(calendar);
    }

    @Override
    public <B extends Appendable> B format(long millis, B buf) {
        return this.printer.format(millis, buf);
    }

    @Override
    public <B extends Appendable> B format(Date date, B buf) {
        return this.printer.format(date, buf);
    }

    @Override
    public <B extends Appendable> B format(Calendar calendar, B buf) {
        return this.printer.format(calendar, buf);
    }

    @Override
    public Date parse(CharSequence source) throws DateException {
        return this.parser.parse(source);
    }

    @Override
    public boolean parse(CharSequence source, ParsePosition pos, Calendar calendar) {
        return this.parser.parse(source, pos, calendar);
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        return this.parser.parse(source, pos);
    }

    @Override
    public String getPattern() {
        return this.printer.getPattern();
    }

    @Override
    public TimeZone getTimeZone() {
        return this.printer.getTimeZone();
    }

    @Override
    public Locale getLocale() {
        return this.printer.getLocale();
    }

    public int getMaxLengthEstimate() {
        return this.printer.getMaxLengthEstimate();
    }

    public DateTimeFormatter getDateTimeFormatter() {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(this.getPattern());
        if (this.getLocale() != null) {
            formatter = formatter.withLocale(this.getLocale());
        }
        if (this.getTimeZone() != null) {
            formatter = formatter.withZone(this.getTimeZone().toZoneId());
        }
        return formatter;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FormatBuilder)) {
            return false;
        }
        FormatBuilder other = (FormatBuilder)object;
        return this.printer.equals(other.printer);
    }

    public int hashCode() {
        return this.printer.hashCode();
    }

    public String toString() {
        return "FastFormat[" + this.printer.getPattern() + "," + String.valueOf(this.printer.getLocale()) + "," + this.printer.getTimeZone().getID() + "]";
    }
}

