/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.date.format;

import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.xyz.DateKit;

public class FormatManager {
    private final Map<CharSequence, Function<Date, String>> formatterMap = new ConcurrentHashMap<CharSequence, Function<Date, String>>();
    private final Map<CharSequence, Function<CharSequence, Date>> parserMap = new ConcurrentHashMap<CharSequence, Function<CharSequence, Date>>();

    public FormatManager() {
        this.registerFormatter("#sss", date -> String.valueOf(Math.floorDiv(date.getTime(), 1000L)));
        this.registerParser("#sss", dateStr -> DateKit.date(Math.multiplyExact(Long.parseLong(dateStr.toString()), 1000L)));
        this.registerFormatter("#SSS", date -> String.valueOf(date.getTime()));
        this.registerParser("#SSS", dateStr -> DateKit.date(Long.parseLong(dateStr.toString())));
    }

    public static FormatManager getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public FormatManager registerFormatter(String format, Function<Date, String> func) {
        Assert.notNull(format, "Format must be not null !", new Object[0]);
        Assert.notNull(func, "Function must be not null !", new Object[0]);
        this.formatterMap.put(format, func);
        return this;
    }

    public FormatManager registerParser(String format, Function<CharSequence, Date> func) {
        Assert.notNull(format, "Format must be not null !", new Object[0]);
        Assert.notNull(func, "Function must be not null !", new Object[0]);
        this.parserMap.put(format, func);
        return this;
    }

    public boolean isCustomFormat(String format) {
        return this.formatterMap != null && this.formatterMap.containsKey(format);
    }

    public boolean isCustomParse(String format) {
        return this.parserMap != null && this.parserMap.containsKey(format);
    }

    public String format(Date date, CharSequence format) {
        Function<Date, String> func;
        if (this.formatterMap != null && (func = this.formatterMap.get(format)) != null) {
            return func.apply(date);
        }
        return null;
    }

    public String format(TemporalAccessor temporalAccessor, CharSequence format) {
        return this.format(DateKit.date(temporalAccessor), format);
    }

    public Date parse(CharSequence date, String format) {
        Function<CharSequence, Date> func;
        if (this.parserMap != null && (func = this.parserMap.get(format)) != null) {
            return func.apply(date);
        }
        return null;
    }

    private static class SingletonHolder {
        private static final FormatManager INSTANCE = new FormatManager();

        private SingletonHolder() {
        }
    }
}

