/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.date.format.parser;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.miaixz.bus.core.center.date.builder.DateBuilder;
import org.miaixz.bus.core.center.date.culture.en.Month;
import org.miaixz.bus.core.center.date.culture.en.Week;
import org.miaixz.bus.core.center.date.format.parser.DateParser;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.Optional;
import org.miaixz.bus.core.lang.exception.DateException;
import org.miaixz.bus.core.text.dfa.WordTree;
import org.miaixz.bus.core.xyz.CharKit;
import org.miaixz.bus.core.xyz.ListKit;
import org.miaixz.bus.core.xyz.PatternKit;
import org.miaixz.bus.core.xyz.StringKit;

public class RegexDateParser
implements DateParser,
Serializable {
    private static final long serialVersionUID = 2852256787361L;
    private static final int[] NSS = new int[]{100000000, 10000000, 1000000, 100000, 10000, 1000, 100, 10, 1};
    private static final Pattern ZONE_OFFSET_PATTERN = Pattern.compile("[-+]\\d{1,2}:?(?:\\d{2})?");
    private static final WordTree ZONE_TREE = WordTree.of(TimeZone.getAvailableIDs());
    private final List<Pattern> patterns;
    private boolean preferMonthFirst;

    public RegexDateParser(List<Pattern> patterns) {
        this.patterns = patterns;
    }

    public static RegexDateParser of(String ... regexes) {
        ArrayList<Pattern> patternList = new ArrayList<Pattern>(regexes.length);
        for (String regex : regexes) {
            patternList.add(Pattern.compile(regex, 2));
        }
        return new RegexDateParser(patternList);
    }

    public static RegexDateParser of(Pattern ... patterns) {
        return new RegexDateParser(ListKit.of(patterns));
    }

    private static void parseNumberDate(String number, DateBuilder dateBuilder) {
        int length = number.length();
        switch (length) {
            case 4: {
                dateBuilder.setYear(Integer.parseInt(number));
                break;
            }
            case 6: {
                dateBuilder.setYear(RegexDateParser.parseInt(number, 0, 4));
                dateBuilder.setMonth(RegexDateParser.parseInt(number, 4, 6));
                break;
            }
            case 8: {
                dateBuilder.setYear(RegexDateParser.parseInt(number, 0, 4));
                dateBuilder.setMonth(RegexDateParser.parseInt(number, 4, 6));
                dateBuilder.setDay(RegexDateParser.parseInt(number, 6, 8));
                break;
            }
            case 14: {
                dateBuilder.setYear(RegexDateParser.parseInt(number, 0, 4));
                dateBuilder.setMonth(RegexDateParser.parseInt(number, 4, 6));
                dateBuilder.setDay(RegexDateParser.parseInt(number, 6, 8));
                dateBuilder.setHour(RegexDateParser.parseInt(number, 8, 10));
                dateBuilder.setMinute(RegexDateParser.parseInt(number, 10, 12));
                dateBuilder.setSecond(RegexDateParser.parseInt(number, 12, 14));
                break;
            }
            case 10: {
                dateBuilder.setUnixsecond(RegexDateParser.parseLong(number));
                break;
            }
            case 13: {
                dateBuilder.setMillisecond(RegexDateParser.parseLong(number));
                break;
            }
            case 16: {
                dateBuilder.setUnixsecond(RegexDateParser.parseLong(number.substring(0, 10)));
                dateBuilder.setNanosecond(RegexDateParser.parseInt(number, 10, 16));
                break;
            }
            case 19: {
                dateBuilder.setUnixsecond(RegexDateParser.parseLong(number.substring(0, 10)));
                dateBuilder.setNanosecond(RegexDateParser.parseInt(number, 10, 19));
            }
        }
    }

    private static int parseYear(String year) {
        int length = year.length();
        switch (length) {
            case 4: {
                return Integer.parseInt(year);
            }
            case 2: {
                int num = Integer.parseInt(year);
                return (num > 50 ? 1900 : 2000) + num;
            }
        }
        throw new DateException("Invalid year: [{}]", new Object[]{year});
    }

    private static void parseDayOrMonth(String dayOrMonth, DateBuilder dateBuilder, boolean preferMonthFirst) {
        int b;
        int a;
        char next = dayOrMonth.charAt(1);
        if (next < '0' || next > '9') {
            a = RegexDateParser.parseInt(dayOrMonth, 0, 1);
            b = RegexDateParser.parseInt(dayOrMonth, 2, dayOrMonth.length());
        } else {
            a = RegexDateParser.parseInt(dayOrMonth, 0, 2);
            b = RegexDateParser.parseInt(dayOrMonth, 3, dayOrMonth.length());
        }
        if (a > 31 || b > 31 || a == 0 || b == 0 || a > 12 && b > 12) {
            throw new DateException("Invalid DayOrMonth : {}", new Object[]{dayOrMonth});
        }
        if (b > 12 || preferMonthFirst && a <= 12) {
            dateBuilder.setMonth(a);
            dateBuilder.setDay(b);
        } else {
            dateBuilder.setMonth(b);
            dateBuilder.setDay(a);
        }
    }

    private static int parseMonth(String month) {
        try {
            int monthInt = Integer.parseInt(month);
            if (monthInt > 0 && monthInt < 13) {
                return monthInt;
            }
        }
        catch (NumberFormatException e) {
            return Month.of(month).getIsoValue();
        }
        throw new DateException("Invalid month: [{}]", new Object[]{month});
    }

    private static int parseWeek(String week) {
        return Week.of(week).getIsoValue();
    }

    private static int parseNumberLimit(String numberStr, int minInclude, int maxInclude) {
        try {
            int numberInt = Integer.parseInt(numberStr);
            if (numberInt >= minInclude && numberInt <= maxInclude) {
                return numberInt;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw new DateException("Invalid number: [{}]", new Object[]{numberStr});
    }

    private static long parseLong(String numberStr) {
        try {
            return Long.parseLong(numberStr);
        }
        catch (NumberFormatException numberFormatException) {
            throw new DateException("Invalid long: [{}]", new Object[]{numberStr});
        }
    }

    private static int parseInt(String numberStr, int from, int to) {
        try {
            return Integer.parseInt(numberStr.substring(from, to));
        }
        catch (NumberFormatException numberFormatException) {
            throw new DateException("Invalid int: [{}]", new Object[]{numberStr});
        }
    }

    private static int parseNano(String ns) {
        return NSS[ns.length() - 1] * Integer.parseInt(ns);
    }

    private static void parseZone(String zone, DateBuilder dateBuilder) {
        String zoneOffset = PatternKit.getGroup0(ZONE_OFFSET_PATTERN, (CharSequence)zone);
        if (StringKit.isNotBlank(zoneOffset)) {
            dateBuilder.setFlag(true);
            dateBuilder.setZoneOffset(RegexDateParser.parseZoneOffset(zoneOffset));
            return;
        }
        String zoneName = ZONE_TREE.match(zone);
        if (StringKit.isNotBlank(zoneName)) {
            dateBuilder.setFlag(true);
            dateBuilder.setZone(TimeZone.getTimeZone(zoneName));
        }
    }

    private static int parseZoneOffset(String zoneOffset) {
        int hour;
        boolean neg;
        int from = 0;
        int to = zoneOffset.length();
        boolean bl = neg = '-' == zoneOffset.charAt(from);
        if (++from + 2 <= to && Character.isDigit(zoneOffset.charAt(from + 1))) {
            hour = RegexDateParser.parseInt(zoneOffset, from, from + 2);
            from += 2;
        } else {
            hour = RegexDateParser.parseInt(zoneOffset, from, from + 1);
            ++from;
        }
        if (from + 3 <= to && zoneOffset.charAt(from) == ':') {
            ++from;
        }
        int minute = 0;
        if (from + 2 <= to) {
            minute = RegexDateParser.parseInt(zoneOffset, from, from + 2);
        }
        return (hour * 60 + minute) * (neg ? -1 : 1);
    }

    public void setPreferMonthFirst(boolean preferMonthFirst) {
        this.preferMonthFirst = preferMonthFirst;
    }

    public RegexDateParser addRegex(String regex) {
        return this.addPattern(Pattern.compile(regex, 2));
    }

    public RegexDateParser addPattern(Pattern pattern) {
        this.patterns.add(pattern);
        return this;
    }

    @Override
    public Date parse(CharSequence source) throws DateException {
        Assert.notBlank(source, "Date source must be not blank!", new Object[0]);
        return this.parseToBuilder(source).toDate();
    }

    private DateBuilder parseToBuilder(CharSequence source) throws DateException {
        DateBuilder dateBuilder = DateBuilder.of();
        for (Pattern pattern : this.patterns) {
            Matcher matcher = pattern.matcher(source);
            if (!matcher.matches()) continue;
            this.parse(matcher, dateBuilder);
            return dateBuilder;
        }
        throw new DateException("No valid pattern for date string: [{}]", source);
    }

    private void parse(Matcher matcher, DateBuilder dateBuilder) throws DateException {
        String number = PatternKit.group(matcher, "number");
        if (StringKit.isNotEmpty(number)) {
            RegexDateParser.parseNumberDate(number, dateBuilder);
            return;
        }
        String millisecond = PatternKit.group(matcher, "millisecond");
        if (StringKit.isNotEmpty(millisecond)) {
            dateBuilder.setMillisecond(RegexDateParser.parseLong(millisecond));
            return;
        }
        Optional.ofNullable(PatternKit.group(matcher, "year")).ifPresent(year -> dateBuilder.setYear(RegexDateParser.parseYear(year)));
        Optional.ofNullable(PatternKit.group(matcher, "dayOrMonth")).ifPresent(dayOrMonth -> RegexDateParser.parseDayOrMonth(dayOrMonth, dateBuilder, this.preferMonthFirst));
        Optional.ofNullable(PatternKit.group(matcher, "month")).ifPresent(month -> dateBuilder.setMonth(RegexDateParser.parseMonth(month)));
        Optional.ofNullable(PatternKit.group(matcher, "week")).ifPresent(week -> dateBuilder.setWeek(RegexDateParser.parseWeek(week)));
        Optional.ofNullable(PatternKit.group(matcher, "day")).ifPresent(day -> dateBuilder.setDay(RegexDateParser.parseNumberLimit(day, 1, 31)));
        Optional.ofNullable(PatternKit.group(matcher, "hour")).ifPresent(hour -> dateBuilder.setHour(RegexDateParser.parseNumberLimit(hour, 0, 23)));
        Optional.ofNullable(PatternKit.group(matcher, "minute")).ifPresent(minute -> dateBuilder.setMinute(RegexDateParser.parseNumberLimit(minute, 0, 59)));
        Optional.ofNullable(PatternKit.group(matcher, "second")).ifPresent(second -> dateBuilder.setSecond(RegexDateParser.parseNumberLimit(second, 0, 59)));
        Optional.ofNullable(PatternKit.group(matcher, "nanosecond")).ifPresent(ns -> dateBuilder.setNanosecond(RegexDateParser.parseNano(ns)));
        Optional.ofNullable(PatternKit.group(matcher, "m")).ifPresent(m -> {
            if (CharKit.equals('p', m.charAt(0), true)) {
                dateBuilder.setPm(true);
            } else {
                dateBuilder.setAm(true);
            }
        });
        Optional.ofNullable(PatternKit.group(matcher, "zero")).ifPresent(zero -> {
            dateBuilder.setFlag(true);
            dateBuilder.setZoneOffset(0);
        });
        Optional.ofNullable(PatternKit.group(matcher, "zone")).ifPresent(zoneOffset -> RegexDateParser.parseZone(zoneOffset, dateBuilder));
        Optional.ofNullable(PatternKit.group(matcher, "zoneOffset")).ifPresent(zoneOffset -> {
            dateBuilder.setFlag(true);
            dateBuilder.setZoneOffset(RegexDateParser.parseZoneOffset(zoneOffset));
        });
        Optional.ofNullable(PatternKit.group(matcher, "unixsecond")).ifPresent(unixsecond -> dateBuilder.setUnixsecond(RegexDateParser.parseLong(unixsecond)));
    }
}

