/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.date.printer;

import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Queue;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.miaixz.bus.core.center.date.format.DatePattern;
import org.miaixz.bus.core.center.date.printer.FormatPrinter;
import org.miaixz.bus.core.center.date.printer.SimpleDatePrinter;
import org.miaixz.bus.core.xyz.StringKit;

public class FastDatePrinter
extends SimpleDatePrinter
implements FormatPrinter {
    private static final long serialVersionUID = 2852257551539L;
    private final DatePattern datePattern;
    private final Queue<Calendar> queue;

    public FastDatePrinter(String pattern, TimeZone timeZone, Locale locale) {
        super(pattern, timeZone, locale);
        this.datePattern = new DatePattern(pattern, locale, timeZone);
        this.queue = new ConcurrentLinkedQueue<Calendar>();
    }

    public String format(Object obj) {
        if (obj instanceof Date) {
            return this.format((Date)obj);
        }
        if (obj instanceof Calendar) {
            return this.format((Calendar)obj);
        }
        if (obj instanceof Long) {
            return this.format((Long)obj);
        }
        throw new IllegalArgumentException("Unknown class: " + (obj == null ? "<null>" : obj.getClass().getName()));
    }

    @Override
    public String format(Date date) {
        return this.format(date.getTime());
    }

    @Override
    public String format(long millis) {
        return this.format(millis, StringKit.builder(this.datePattern.getEstimateLength())).toString();
    }

    @Override
    public String format(Calendar calendar) {
        return this.format(calendar, StringKit.builder(this.datePattern.getEstimateLength())).toString();
    }

    @Override
    public <B extends Appendable> B format(Date date, B buf) {
        return this.format(date.getTime(), buf);
    }

    @Override
    public <B extends Appendable> B format(long millis, B buf) {
        return this.applyRules(millis, buf);
    }

    @Override
    public <B extends Appendable> B format(Calendar calendar, B buf) {
        if (!calendar.getTimeZone().equals(this.timeZone)) {
            calendar = (Calendar)calendar.clone();
            calendar.setTimeZone(this.timeZone);
        }
        return this.datePattern.applyRules(calendar, buf);
    }

    private <B extends Appendable> B applyRules(long millis, B buf) {
        Calendar calendar = this.queue.poll();
        if (calendar == null) {
            calendar = Calendar.getInstance(this.timeZone, this.locale);
        }
        calendar.setTimeInMillis(millis);
        B b = this.datePattern.applyRules(calendar, buf);
        this.queue.offer(calendar);
        return b;
    }

    public int getMaxLengthEstimate() {
        return this.datePattern.getEstimateLength();
    }
}

