/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.function;

import java.io.Serializable;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import org.miaixz.bus.core.xyz.ExceptionKit;

@FunctionalInterface
public interface BiConsumerX<T, U>
extends BiConsumer<T, U>,
Serializable {
    @SafeVarargs
    public static <T, U> BiConsumerX<T, U> multi(BiConsumerX<T, U> ... consumers) {
        return Stream.of(consumers).reduce(BiConsumerX::andThen).orElseGet(() -> (o, q) -> {});
    }

    public static <T, U> BiConsumerX<T, U> nothing() {
        return (l, r) -> {};
    }

    public void accepting(T var1, U var2) throws Throwable;

    @Override
    default public void accept(T t, U u) {
        try {
            this.accepting(t, u);
        }
        catch (Throwable e) {
            throw ExceptionKit.wrapRuntime(e);
        }
    }

    @Override
    default public BiConsumerX<T, U> andThen(BiConsumerX<? super T, ? super U> after) {
        Objects.requireNonNull(after);
        return (l, r) -> {
            this.accepting(l, r);
            after.accepting(l, r);
        };
    }
}

