/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.function;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.BinaryOperator;
import org.miaixz.bus.core.xyz.ExceptionKit;

@FunctionalInterface
public interface BinaryOperatorX<T>
extends BinaryOperator<T>,
Serializable {
    public static <T> BinaryOperatorX<T> minBy(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator);
        return (a, b) -> comparator.compare(a, b) <= 0 ? a : b;
    }

    public static <T> BinaryOperatorX<T> maxBy(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator);
        return (a, b) -> comparator.compare(a, b) >= 0 ? a : b;
    }

    public static <T> BinaryOperatorX<T> justBefore() {
        return (l, r) -> l;
    }

    public static <T> BinaryOperatorX<T> justAfter() {
        return (l, r) -> r;
    }

    public T applying(T var1, T var2) throws Throwable;

    @Override
    default public T apply(T t, T u) {
        try {
            return this.applying(t, u);
        }
        catch (Throwable e) {
            throw ExceptionKit.wrapRuntime(e);
        }
    }
}

