/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.iterator;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.miaixz.bus.core.center.CollectionValidator;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.xyz.MathKit;
import org.miaixz.bus.core.xyz.StringKit;

public class IteratorValidator {
    public static boolean isEmpty(Iterable<?> iterable) {
        return null == iterable || IteratorValidator.isEmpty(iterable.iterator());
    }

    public static boolean isEmpty(Iterator<?> iterator) {
        return null == iterator || !iterator.hasNext();
    }

    public static boolean isNotEmpty(Iterable<?> iterable) {
        return null != iterable && IteratorValidator.isNotEmpty(iterable.iterator());
    }

    public static boolean isNotEmpty(Iterator<?> iterator) {
        return null != iterator && iterator.hasNext();
    }

    public static boolean hasNull(Iterator<?> iter) {
        if (null == iter) {
            return true;
        }
        while (iter.hasNext()) {
            if (null != iter.next()) continue;
            return true;
        }
        return false;
    }

    public static boolean isAllNull(Iterable<?> iter) {
        return IteratorValidator.isAllNull(null == iter ? null : iter.iterator());
    }

    public static boolean isAllNull(Iterator<?> iter) {
        return null == IteratorValidator.getFirstNoneNull(iter);
    }

    public static boolean hasBlank(Iterable<? extends CharSequence> args) {
        if (CollectionValidator.isEmpty(args)) {
            return true;
        }
        for (CharSequence charSequence : args) {
            if (!StringKit.isBlank(charSequence)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAllBlank(Iterable<? extends CharSequence> args) {
        if (CollectionValidator.isNotEmpty(args)) {
            for (CharSequence charSequence : args) {
                if (!StringKit.isNotBlank(charSequence)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isSub(Iterable<?> subIter, Iterable<?> iter) {
        if (subIter == iter) {
            return true;
        }
        if (subIter == null || iter == null) {
            return false;
        }
        Map<?, Integer> countMap1 = IteratorValidator.countMap(subIter.iterator());
        Map<?, Integer> countMap2 = IteratorValidator.countMap(iter.iterator());
        for (Object object : subIter) {
            if (MathKit.nullToZero(countMap1.get(object)) <= MathKit.nullToZero(countMap2.get(object))) continue;
            return false;
        }
        return true;
    }

    public static boolean isEqualList(Iterable<?> iterable1, Iterable<?> iterable2) {
        return IteratorValidator.equals(iterable1, iterable2, false);
    }

    public static boolean equals(Iterable<?> iterable1, Iterable<?> iterable2, boolean ignoreOrder) {
        if (iterable1 == iterable2) {
            return true;
        }
        if (iterable1 == null || iterable2 == null) {
            return false;
        }
        if (ignoreOrder) {
            Map<?, Integer> countMap1 = IteratorValidator.countMap(iterable1.iterator());
            Map<?, Integer> countMap2 = IteratorValidator.countMap(iterable2.iterator());
            if (countMap1.size() != countMap2.size()) {
                return false;
            }
            for (Object object : iterable1) {
                if (MathKit.nullToZero(countMap1.get(object)) == MathKit.nullToZero(countMap2.get(object))) continue;
                return false;
            }
            return true;
        }
        Iterator<?> iter1 = iterable1.iterator();
        Iterator<?> iter2 = iterable2.iterator();
        while (iter1.hasNext() && iter2.hasNext()) {
            Object obj2;
            Object obj1 = iter1.next();
            if (Objects.equals(obj1, obj2 = iter2.next())) continue;
            return false;
        }
        return !iter1.hasNext() && !iter2.hasNext();
    }

    public static <E> E get(Iterator<E> iterator, int index) throws IndexOutOfBoundsException {
        if (null == iterator) {
            return null;
        }
        Assert.isTrue(index >= 0, "[index] must be >= 0", new Object[0]);
        while (iterator.hasNext()) {
            if (-1 == --index) {
                return iterator.next();
            }
            iterator.next();
        }
        return null;
    }

    public static <T> T getFirst(Iterator<T> iterator) {
        return IteratorValidator.get(iterator, 0);
    }

    public static <T> T getFirst(Iterator<T> iterator, Predicate<T> predicate) {
        Assert.notNull(predicate, "Matcher must be not null !", new Object[0]);
        if (null != iterator) {
            while (iterator.hasNext()) {
                T next = iterator.next();
                if (!predicate.test(next)) continue;
                return next;
            }
        }
        return null;
    }

    public static <T> T getFirstNoneNull(Iterator<T> iterator) {
        return (T)IteratorValidator.getFirst(iterator, Objects::nonNull);
    }

    public static <T> Map<T, Integer> countMap(Iterator<T> iter) {
        HashMap<T, Integer> countMap = new HashMap<T, Integer>();
        if (null != iter) {
            while (iter.hasNext()) {
                countMap.merge(iter.next(), 1, Integer::sum);
            }
        }
        return countMap;
    }
}

