/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.iterator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.miaixz.bus.core.center.iterator.IterableIterator;
import org.miaixz.bus.core.lang.Assert;

public class PartitionIterator<T>
implements IterableIterator<List<T>>,
Serializable {
    private static final long serialVersionUID = 2852267311619L;
    protected final Iterator<T> iterator;
    protected final int partitionSize;

    public PartitionIterator(Iterator<T> iterator, int partitionSize) {
        Assert.isTrue(partitionSize > 0, "partition size must greater than 0", new Object[0]);
        this.iterator = Objects.requireNonNull(iterator);
        this.partitionSize = partitionSize;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public List<T> next() {
        ArrayList<T> list = new ArrayList<T>(this.partitionSize);
        for (int i = 0; i < this.partitionSize && this.iterator.hasNext(); ++i) {
            list.add(this.iterator.next());
        }
        return list;
    }
}

