/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.map;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;

public class FixedLinkedHashMap<K, V>
extends LinkedHashMap<K, V> {
    private static final long serialVersionUID = 2852273311867L;
    private int capacity;
    private Consumer<Map.Entry<K, V>> removeListener;

    public FixedLinkedHashMap(int capacity) {
        super(capacity + 1, 1.0f, true);
        this.capacity = capacity;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public void setRemoveListener(Consumer<Map.Entry<K, V>> removeListener) {
        this.removeListener = removeListener;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        if (this.size() > this.capacity) {
            if (null != this.removeListener) {
                this.removeListener.accept(eldest);
            }
            return true;
        }
        return false;
    }
}

