/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.queue;

import java.util.Collection;
import java.util.function.Predicate;
import org.miaixz.bus.core.center.queue.CheckedLinkedBlockingQueue;
import org.miaixz.bus.core.lang.Console;
import org.miaixz.bus.core.lang.thread.SimpleScheduler;
import org.miaixz.bus.core.xyz.RuntimeKit;

public class MemorySafeLinkedBlockingQueue<E>
extends CheckedLinkedBlockingQueue<E> {
    private static final long serialVersionUID = 2852279836896L;

    public MemorySafeLinkedBlockingQueue(long maxFreeMemory) {
        super(new MemoryChecker(maxFreeMemory));
    }

    public MemorySafeLinkedBlockingQueue(Collection<? extends E> c, long maxFreeMemory) {
        super(c, new MemoryChecker(maxFreeMemory));
    }

    public long getMaxFreeMemory() {
        return ((MemoryChecker)this.checker).maxFreeMemory;
    }

    public void setMaxFreeMemory(int maxFreeMemory) {
        ((MemoryChecker)this.checker).maxFreeMemory = maxFreeMemory;
    }

    private static class MemoryChecker<E>
    implements Predicate<E> {
        private long maxFreeMemory;

        private MemoryChecker(long maxFreeMemory) {
            this.maxFreeMemory = maxFreeMemory;
        }

        @Override
        public boolean test(E e) {
            Console.log(FreeMemoryCalculator.INSTANCE.getResult());
            return (Long)FreeMemoryCalculator.INSTANCE.getResult() > this.maxFreeMemory;
        }
    }

    private static class FreeMemoryCalculator
    extends SimpleScheduler<Long> {
        private static final FreeMemoryCalculator INSTANCE = new FreeMemoryCalculator();

        FreeMemoryCalculator() {
            super(new SimpleScheduler.Job<Long>(){
                private volatile long maxAvailable = RuntimeKit.getFreeMemory();

                @Override
                public Long getResult() {
                    return this.maxAvailable;
                }

                @Override
                public void run() {
                    this.maxAvailable = RuntimeKit.getFreeMemory();
                }
            }, 50L);
        }
    }
}

