/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.codec.binary;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.miaixz.bus.core.codec.binary.provider.Base62Provider;
import org.miaixz.bus.core.xyz.ByteKit;
import org.miaixz.bus.core.xyz.FileKit;
import org.miaixz.bus.core.xyz.IoKit;
import org.miaixz.bus.core.xyz.StringKit;

public class Base62 {
    private static final Charset DEFAULT_CHARSET = org.miaixz.bus.core.lang.Charset.UTF_8;

    public static String encode(CharSequence source) {
        return Base62.encode(source, DEFAULT_CHARSET);
    }

    public static String encode(CharSequence source, Charset charset) {
        return Base62.encode(ByteKit.toBytes(source, charset));
    }

    public static String encode(byte[] source) {
        return new String(Base62Provider.INSTANCE.encode(source));
    }

    public static String encode(InputStream in) {
        return Base62.encode(IoKit.readBytes(in));
    }

    public static String encode(File file) {
        return Base62.encode(FileKit.readBytes(file));
    }

    public static String encodeInverted(CharSequence source) {
        return Base62.encodeInverted(source, DEFAULT_CHARSET);
    }

    public static String encodeInverted(CharSequence source, Charset charset) {
        return Base62.encodeInverted(ByteKit.toBytes(source, charset));
    }

    public static String encodeInverted(byte[] source) {
        return new String(Base62Provider.INSTANCE.encode(source, true));
    }

    public static String encodeInverted(InputStream in) {
        return Base62.encodeInverted(IoKit.readBytes(in));
    }

    public static String encodeInverted(File file) {
        return Base62.encodeInverted(FileKit.readBytes(file));
    }

    public static String decodeString(CharSequence source) {
        return Base62.decodeString(source, DEFAULT_CHARSET);
    }

    public static String decodeString(CharSequence source, Charset charset) {
        return StringKit.toString(Base62.decode(source), charset);
    }

    public static File decodeToFile(CharSequence Base622, File destFile) {
        return FileKit.writeBytes(Base62.decode(Base622), destFile);
    }

    public static void decodeToStream(CharSequence base62Str, OutputStream out, boolean isCloseOut) {
        IoKit.write(out, isCloseOut, Base62.decode(base62Str));
    }

    public static byte[] decode(CharSequence base62Str) {
        return Base62.decode(ByteKit.toBytes(base62Str, DEFAULT_CHARSET));
    }

    public static byte[] decode(byte[] base62bytes) {
        return Base62Provider.INSTANCE.decode(base62bytes);
    }

    public static String decodeStrInverted(CharSequence source) {
        return Base62.decodeStrInverted(source, DEFAULT_CHARSET);
    }

    public static String decodeStrInverted(CharSequence source, Charset charset) {
        return StringKit.toString(Base62.decodeInverted(source), charset);
    }

    public static File decodeToFileInverted(CharSequence Base622, File destFile) {
        return FileKit.writeBytes(Base62.decodeInverted(Base622), destFile);
    }

    public static void decodeToStreamInverted(CharSequence base62Str, OutputStream out, boolean isCloseOut) {
        IoKit.write(out, isCloseOut, Base62.decodeInverted(base62Str));
    }

    public static byte[] decodeInverted(CharSequence base62Str) {
        return Base62.decodeInverted(ByteKit.toBytes(base62Str, DEFAULT_CHARSET));
    }

    public static byte[] decodeInverted(byte[] base62bytes) {
        return Base62Provider.INSTANCE.decode(base62bytes, true);
    }
}

