/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.codec.binary.encoder;

import org.miaixz.bus.core.codec.Encoder;

public class Base32Encoder
implements Encoder<byte[], String> {
    public static final String DEFAULT_ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZ234567";
    public static final String HEX_ALPHABET = "0123456789ABCDEFGHIJKLMNOPQRSTUV";
    public static final Base32Encoder ENCODER = new Base32Encoder("ABCDEFGHIJKLMNOPQRSTUVWXYZ234567", Character.valueOf('='));
    public static final Base32Encoder HEX_ENCODER = new Base32Encoder("0123456789ABCDEFGHIJKLMNOPQRSTUV", Character.valueOf('='));
    private static final int[] BASE32_FILL = new int[]{-1, 4, 1, 6, 3};
    private final char[] alphabet;
    private final Character pad;

    public Base32Encoder(String alphabet, Character pad) {
        this.alphabet = alphabet.toCharArray();
        this.pad = pad;
    }

    @Override
    public String encode(byte[] data) {
        int i = 0;
        int index = 0;
        int encodeLen = data.length * 8 / 5;
        if (encodeLen != 0) {
            encodeLen = encodeLen + 1 + BASE32_FILL[data.length * 8 % 5];
        }
        StringBuilder base32 = new StringBuilder(encodeLen);
        while (i < data.length) {
            int digit;
            int currByte;
            int n = currByte = data[i] >= 0 ? data[i] : data[i] + 256;
            if (index > 3) {
                int nextByte = i + 1 < data.length ? (data[i + 1] >= 0 ? data[i + 1] : data[i + 1] + 256) : 0;
                digit = currByte & 255 >> index;
                index = (index + 5) % 8;
                digit <<= index;
                digit |= nextByte >> 8 - index;
                ++i;
            } else {
                digit = currByte >> 8 - (index + 5) & 0x1F;
                if ((index = (index + 5) % 8) == 0) {
                    ++i;
                }
            }
            base32.append(this.alphabet[digit]);
        }
        if (null != this.pad) {
            while (base32.length() < encodeLen) {
                base32.append(this.pad.charValue());
            }
        }
        return base32.toString();
    }
}

