/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.codec.binary.encoder;

import org.miaixz.bus.core.codec.Encoder;
import org.miaixz.bus.core.codec.binary.provider.Base62Provider;

public class Base62Encoder
implements Encoder<byte[], byte[]> {
    public static final byte[] GMP = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122};
    public static final byte[] INVERTED = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90};
    public static Base62Encoder GMP_ENCODER = new Base62Encoder(GMP);
    public static Base62Encoder INVERTED_ENCODER = new Base62Encoder(INVERTED);
    private final byte[] alphabet;

    public Base62Encoder(byte[] alphabet) {
        this.alphabet = alphabet;
    }

    @Override
    public byte[] encode(byte[] data) {
        byte[] indices = Base62Provider.convert(data, 512, 62);
        return Base62Provider.translate(indices, this.alphabet);
    }
}

