/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.codec.binary.provider;

import java.io.Serializable;
import org.miaixz.bus.core.codec.Decoder;
import org.miaixz.bus.core.codec.Encoder;
import org.miaixz.bus.core.codec.binary.decoder.Base58Decoder;
import org.miaixz.bus.core.codec.binary.encoder.Base58Encoder;

public class Base58Provider
implements Encoder<byte[], String>,
Decoder<CharSequence, byte[]>,
Serializable {
    private static final long serialVersionUID = 2852258919299L;
    public static Base58Provider INSTANCE = new Base58Provider();

    public static byte divmod(byte[] number, int firstDigit, int base, int divisor) {
        int remainder = 0;
        for (int i = firstDigit; i < number.length; ++i) {
            int digit = number[i] & 0xFF;
            int temp = remainder * base + digit;
            number[i] = (byte)(temp / divisor);
            remainder = temp % divisor;
        }
        return (byte)remainder;
    }

    @Override
    public String encode(byte[] data) {
        return Base58Encoder.ENCODER.encode(data);
    }

    @Override
    public byte[] decode(CharSequence encoded) throws IllegalArgumentException {
        return Base58Decoder.DECODER.decode(encoded);
    }
}

