/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.codec.binary.provider;

import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import org.miaixz.bus.core.codec.Decoder;
import org.miaixz.bus.core.codec.Encoder;
import org.miaixz.bus.core.codec.binary.decoder.Base62Decoder;
import org.miaixz.bus.core.codec.binary.encoder.Base62Encoder;
import org.miaixz.bus.core.xyz.ArrayKit;

public class Base62Provider
implements Encoder<byte[], byte[]>,
Decoder<byte[], byte[]>,
Serializable {
    public static final long serialVersionUID = 2852259077806L;
    public static Base62Provider INSTANCE = new Base62Provider();

    public static byte[] translate(byte[] indices, byte[] dictionary) {
        byte[] translation = new byte[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            translation[i] = dictionary[indices[i]];
        }
        return translation;
    }

    public static byte[] convert(byte[] message, int sourceBase, int targetBase) {
        int estimatedLength = Base62Provider.estimateOutputLength(message.length, sourceBase, targetBase);
        ByteArrayOutputStream out = new ByteArrayOutputStream(estimatedLength);
        byte[] source = message;
        while (source.length > 0) {
            ByteArrayOutputStream quotient = new ByteArrayOutputStream(source.length);
            int remainder = 0;
            for (byte b : source) {
                int accumulator = (b & 0xFF) + remainder * sourceBase;
                int digit = (accumulator - accumulator % targetBase) / targetBase;
                remainder = accumulator % targetBase;
                if (quotient.size() <= 0 && digit <= 0) continue;
                quotient.write(digit);
            }
            out.write(remainder);
            source = quotient.toByteArray();
        }
        for (int i = 0; i < message.length - 1 && message[i] == 0; ++i) {
            out.write(0);
        }
        return ArrayKit.reverse(out.toByteArray());
    }

    private static int estimateOutputLength(int inputLength, int sourceBase, int targetBase) {
        return (int)Math.ceil(Math.log(sourceBase) / Math.log(targetBase) * (double)inputLength);
    }

    @Override
    public byte[] encode(byte[] data) {
        return this.encode(data, false);
    }

    public byte[] encode(byte[] data, boolean useInverted) {
        Base62Encoder encoder = useInverted ? Base62Encoder.INVERTED_ENCODER : Base62Encoder.GMP_ENCODER;
        return encoder.encode(data);
    }

    @Override
    public byte[] decode(byte[] encoded) {
        return this.decode(encoded, false);
    }

    public byte[] decode(byte[] encoded, boolean useInverted) {
        Base62Decoder decoder = useInverted ? Base62Decoder.INVERTED_DECODER : Base62Decoder.GMP_DECODER;
        return decoder.decode(encoded);
    }
}

