/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.convert;

import java.io.Serializable;
import java.lang.reflect.Type;
import org.miaixz.bus.core.convert.Converter;
import org.miaixz.bus.core.lang.exception.ConvertException;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.CharKit;
import org.miaixz.bus.core.xyz.TypeKit;

public abstract class AbstractConverter
implements Converter,
Serializable {
    private static final long serialVersionUID = 2852263159195L;

    @Override
    public Object convert(Type targetType, Object value) throws ConvertException {
        if (null == value) {
            return null;
        }
        if (TypeKit.isUnknown(targetType)) {
            throw new ConvertException("Unsupported support to unKnown type: {}", targetType);
        }
        Class<?> targetClass = TypeKit.getClass(targetType);
        if (null == targetClass) {
            throw new ConvertException("Target type [{}] is not a class!", targetType);
        }
        if (targetClass.isInstance(value)) {
            return value;
        }
        return this.convertInternal(targetClass, value);
    }

    protected abstract Object convertInternal(Class<?> var1, Object var2);

    protected String convertToString(Object value) {
        if (null == value) {
            return null;
        }
        if (value instanceof CharSequence) {
            return value.toString();
        }
        if (ArrayKit.isArray(value)) {
            return ArrayKit.toString(value);
        }
        if (CharKit.isChar(value)) {
            return CharKit.toString(((Character)value).charValue());
        }
        return value.toString();
    }
}

