/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.convert;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Optional;
import org.miaixz.bus.core.convert.BeanConverter;
import org.miaixz.bus.core.convert.Converter;
import org.miaixz.bus.core.convert.MatcherConverter;
import org.miaixz.bus.core.convert.RegisterConverter;
import org.miaixz.bus.core.convert.SpecialConverter;
import org.miaixz.bus.core.lang.exception.ConvertException;
import org.miaixz.bus.core.lang.reflect.TypeReference;
import org.miaixz.bus.core.xyz.BeanKit;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.core.xyz.TypeKit;

public class CompositeConverter
implements Converter,
Serializable {
    private static final long serialVersionUID = 2852267583368L;
    private RegisterConverter registerConverter;
    private SpecialConverter specialConverter;

    private CompositeConverter() {
    }

    public static CompositeConverter getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public CompositeConverter register(MatcherConverter converter) {
        this.registerConverter.register(converter);
        return this;
    }

    public CompositeConverter register(Type type, Converter converter) {
        this.registerConverter.register(type, converter);
        return this;
    }

    @Override
    public Object convert(Type type, Object value) throws ConvertException {
        return this.convert(type, value, null);
    }

    @Override
    public <T> T convert(Type type, Object value, T defaultValue) throws ConvertException {
        return this.convert(type, value, defaultValue, true);
    }

    public <T> T convert(Type type, Object value, T defaultValue, boolean isCustomFirst) throws ConvertException {
        Object result;
        Converter converter;
        if (ObjectKit.isNull(value)) {
            return defaultValue;
        }
        if (TypeKit.isUnknown(type)) {
            if (null == defaultValue) {
                return (T)value;
            }
            type = defaultValue.getClass();
        }
        if (value instanceof org.miaixz.bus.core.lang.Optional && ObjectKit.isNull(value = ((org.miaixz.bus.core.lang.Optional)value).getOrNull())) {
            return defaultValue;
        }
        if (value instanceof Optional && ObjectKit.isNull(value = ((org.miaixz.bus.core.lang.Optional)value).orElse(null))) {
            return defaultValue;
        }
        if (value instanceof Converter) {
            return ((Converter)value).convert(type, value, defaultValue);
        }
        if (type instanceof TypeReference) {
            type = ((TypeReference)type).getType();
        }
        if (null != (converter = this.registerConverter.getConverter(type, value, isCustomFirst))) {
            return converter.convert(type, value, defaultValue);
        }
        Class<?> rawType = TypeKit.getClass(type);
        if (null == rawType) {
            if (null != defaultValue) {
                rawType = defaultValue.getClass();
            } else {
                throw new ConvertException("Can not get class from type: {}", type);
            }
        }
        if (null != (result = this.specialConverter.convert(type, rawType, value))) {
            return (T)result;
        }
        if (BeanKit.isWritableBean(rawType)) {
            return (T)BeanConverter.INSTANCE.convert(type, value);
        }
        throw new ConvertException("Can not support from {}: [{}] to [{}]", value.getClass().getName(), value, type.getTypeName());
    }

    private static class SingletonHolder {
        private static final CompositeConverter INSTANCE = new CompositeConverter();

        private SingletonHolder() {
        }

        static {
            SingletonHolder.INSTANCE.registerConverter = new RegisterConverter(INSTANCE);
            SingletonHolder.INSTANCE.specialConverter = new SpecialConverter(INSTANCE);
        }
    }
}

