/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.convert;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Map;
import org.miaixz.bus.core.convert.Converter;
import org.miaixz.bus.core.convert.ConverterWithRoot;
import org.miaixz.bus.core.convert.MatcherConverter;
import org.miaixz.bus.core.lang.Wrapper;
import org.miaixz.bus.core.lang.exception.ConvertException;
import org.miaixz.bus.core.lang.reflect.TypeReference;
import org.miaixz.bus.core.lang.tuple.Pair;
import org.miaixz.bus.core.xyz.BeanKit;
import org.miaixz.bus.core.xyz.MapKit;
import org.miaixz.bus.core.xyz.ReflectKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.core.xyz.TypeKit;

public class EntryConverter
extends ConverterWithRoot
implements MatcherConverter,
Serializable {
    private static final long serialVersionUID = 2852268537319L;

    public EntryConverter(Converter converter) {
        super(converter);
    }

    private static Map<CharSequence, CharSequence> strToMap(CharSequence text) {
        int index = StringKit.indexOf(text, c -> c.charValue() == ':' || c.charValue() == '=' || c.charValue() == ',', 0, text.length());
        if (index > -1) {
            return MapKit.of(text.subSequence(0, index), text.subSequence(index + 1, text.length()));
        }
        return null;
    }

    @Override
    public Object convert(Type targetType, Object value) throws ConvertException {
        if (targetType instanceof TypeReference) {
            targetType = ((TypeReference)targetType).getType();
        }
        Type keyType = TypeKit.getTypeArgument(targetType, 0);
        Type valueType = TypeKit.getTypeArgument(targetType, 1);
        return this.convert(targetType, keyType, valueType, value);
    }

    public Map.Entry<?, ?> convert(Type targetType, Type keyType, Type valueType, Object value) throws ConvertException {
        Map<Object, Object> map = null;
        if (value instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)value;
            map = MapKit.of(entry.getKey(), entry.getValue());
        } else if (value instanceof Pair) {
            Pair entry = (Pair)value;
            map = MapKit.of(entry.getLeft(), entry.getRight());
        } else if (value instanceof Map) {
            map = (Map)value;
        } else if (value instanceof CharSequence) {
            CharSequence text = (CharSequence)value;
            map = EntryConverter.strToMap(text);
        } else if (BeanKit.isWritableBean(value.getClass())) {
            map = BeanKit.toBeanMap(value);
        }
        if (null != map) {
            return this.mapToEntry(targetType, keyType, valueType, map);
        }
        throw new ConvertException("Unsupported to map from [{}] of type: {}", value, value.getClass().getName());
    }

    @Override
    public boolean match(Type targetType, Class<?> rawType, Object value) {
        return Map.Entry.class.isAssignableFrom(rawType);
    }

    private Map.Entry<?, ?> mapToEntry(Type targetType, Type keyType, Type valueType, Map map) {
        Object value;
        Object key;
        if (1 == map.size()) {
            Map.Entry entry = map.entrySet().iterator().next();
            key = entry.getKey();
            value = entry.getValue();
        } else {
            key = map.get("key");
            value = map.get("value");
        }
        if (value instanceof Wrapper) {
            value = ((Wrapper)value).getRaw();
        }
        return (Map.Entry)ReflectKit.newInstance(TypeKit.getClass(targetType), TypeKit.isUnknown(keyType) ? key : this.converter.convert(keyType, key), TypeKit.isUnknown(valueType) ? value : this.converter.convert(valueType, value));
    }
}

