/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.convert;

import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Currency;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.datatype.XMLGregorianCalendar;
import org.miaixz.bus.core.center.set.ConcurrentHashSet;
import org.miaixz.bus.core.convert.AtomicBooleanConverter;
import org.miaixz.bus.core.convert.AtomicIntegerArrayConverter;
import org.miaixz.bus.core.convert.AtomicLongArrayConverter;
import org.miaixz.bus.core.convert.AtomicReferenceConverter;
import org.miaixz.bus.core.convert.BooleanConverter;
import org.miaixz.bus.core.convert.CalendarConverter;
import org.miaixz.bus.core.convert.CharacterConverter;
import org.miaixz.bus.core.convert.CharsetConverter;
import org.miaixz.bus.core.convert.Converter;
import org.miaixz.bus.core.convert.ConverterWithRoot;
import org.miaixz.bus.core.convert.CurrencyConverter;
import org.miaixz.bus.core.convert.DurationConverter;
import org.miaixz.bus.core.convert.LocaleConverter;
import org.miaixz.bus.core.convert.MatcherConverter;
import org.miaixz.bus.core.convert.OptConverter;
import org.miaixz.bus.core.convert.OptionalConverter;
import org.miaixz.bus.core.convert.PairConverter;
import org.miaixz.bus.core.convert.PathConverter;
import org.miaixz.bus.core.convert.PeriodConverter;
import org.miaixz.bus.core.convert.ReferenceConverter;
import org.miaixz.bus.core.convert.StackTraceElementConverter;
import org.miaixz.bus.core.convert.StringConverter;
import org.miaixz.bus.core.convert.TemporalAccessorConverter;
import org.miaixz.bus.core.convert.TripletConverter;
import org.miaixz.bus.core.convert.TupleConverter;
import org.miaixz.bus.core.convert.URIConverter;
import org.miaixz.bus.core.convert.URLConverter;
import org.miaixz.bus.core.convert.UUIDConverter;
import org.miaixz.bus.core.convert.XMLGregorianCalendarConverter;
import org.miaixz.bus.core.lang.Optional;
import org.miaixz.bus.core.lang.exception.ConvertException;
import org.miaixz.bus.core.lang.tuple.Pair;
import org.miaixz.bus.core.lang.tuple.Triplet;
import org.miaixz.bus.core.lang.tuple.Tuple;
import org.miaixz.bus.core.xyz.StreamKit;
import org.miaixz.bus.core.xyz.TypeKit;

public class RegisterConverter
extends ConverterWithRoot
implements Serializable {
    private static final long serialVersionUID = 2852271620270L;
    private final Map<Class<?>, Converter> defaultConverterMap;
    private volatile Set<MatcherConverter> converterSet;
    private volatile Map<Type, Converter> customConverterMap;

    public RegisterConverter(Converter rootConverter) {
        super(rootConverter);
        this.defaultConverterMap = RegisterConverter.initDefault(rootConverter);
    }

    private static Map<Class<?>, Converter> initDefault(Converter rootConverter) {
        ConcurrentHashMap converterMap = new ConcurrentHashMap(64);
        converterMap.put(Character.class, CharacterConverter.INSTANCE);
        converterMap.put(Boolean.class, BooleanConverter.INSTANCE);
        converterMap.put(AtomicBoolean.class, AtomicBooleanConverter.INSTANCE);
        StringConverter stringConverter = new StringConverter();
        converterMap.put(CharSequence.class, stringConverter);
        converterMap.put(String.class, stringConverter);
        converterMap.put(URI.class, new URIConverter());
        converterMap.put(URL.class, new URLConverter());
        converterMap.put(Calendar.class, new CalendarConverter());
        try {
            converterMap.put(XMLGregorianCalendar.class, new XMLGregorianCalendarConverter());
        }
        catch (Exception exception) {
            // empty catch block
        }
        converterMap.put(TemporalAccessor.class, TemporalAccessorConverter.INSTANCE);
        converterMap.put(Instant.class, TemporalAccessorConverter.INSTANCE);
        converterMap.put(LocalDateTime.class, TemporalAccessorConverter.INSTANCE);
        converterMap.put(LocalDate.class, TemporalAccessorConverter.INSTANCE);
        converterMap.put(LocalTime.class, TemporalAccessorConverter.INSTANCE);
        converterMap.put(ZonedDateTime.class, TemporalAccessorConverter.INSTANCE);
        converterMap.put(OffsetDateTime.class, TemporalAccessorConverter.INSTANCE);
        converterMap.put(OffsetTime.class, TemporalAccessorConverter.INSTANCE);
        converterMap.put(DayOfWeek.class, TemporalAccessorConverter.INSTANCE);
        converterMap.put(Month.class, TemporalAccessorConverter.INSTANCE);
        converterMap.put(MonthDay.class, TemporalAccessorConverter.INSTANCE);
        converterMap.put(Period.class, new PeriodConverter());
        converterMap.put(Duration.class, new DurationConverter());
        ReferenceConverter referenceConverter = new ReferenceConverter(rootConverter);
        converterMap.put(WeakReference.class, referenceConverter);
        converterMap.put(SoftReference.class, referenceConverter);
        converterMap.put(AtomicReference.class, new AtomicReferenceConverter(rootConverter));
        converterMap.put(AtomicIntegerArray.class, new AtomicIntegerArrayConverter());
        converterMap.put(AtomicLongArray.class, new AtomicLongArrayConverter());
        converterMap.put(Locale.class, new LocaleConverter());
        converterMap.put(Charset.class, new CharsetConverter());
        converterMap.put(Path.class, new PathConverter());
        converterMap.put(Currency.class, new CurrencyConverter());
        converterMap.put(UUID.class, new UUIDConverter());
        converterMap.put(StackTraceElement.class, new StackTraceElementConverter());
        converterMap.put(java.util.Optional.class, new OptionalConverter());
        converterMap.put(Optional.class, new OptConverter());
        converterMap.put(Pair.class, new PairConverter(rootConverter));
        converterMap.put(Triplet.class, new TripletConverter(rootConverter));
        converterMap.put(Tuple.class, TupleConverter.INSTANCE);
        return converterMap;
    }

    @Override
    public Object convert(Type targetType, Object value) throws ConvertException {
        Converter converter = this.getConverter(targetType, value, true);
        if (null != converter) {
            return converter.convert(targetType, value);
        }
        throw new ConvertException("Can not support from {}: [{}] to [{}]", value.getClass().getName(), value, targetType.getTypeName());
    }

    public Converter getConverter(Type type, Object value, boolean isCustomFirst) {
        Converter converter;
        if (isCustomFirst) {
            converter = this.getCustomConverter(type, value);
            if (null == converter) {
                converter = this.getCustomConverter(type);
            }
            if (null == converter) {
                converter = this.getDefaultConverter(type);
            }
        } else {
            converter = this.getDefaultConverter(type);
            if (null == converter) {
                converter = this.getCustomConverter(type, value);
            }
            if (null == converter) {
                converter = this.getCustomConverter(type);
            }
        }
        return converter;
    }

    public Converter getDefaultConverter(Type type) {
        Class<?> key = null == type ? null : TypeKit.getClass(type);
        return null == this.defaultConverterMap || null == key ? null : this.defaultConverterMap.get(key);
    }

    public Converter getCustomConverter(Type type, Object value) {
        return StreamKit.of(this.converterSet).filter(predicate -> predicate.match(type, value)).findFirst().orElse(null);
    }

    public Converter getCustomConverter(Type type) {
        return null == this.customConverterMap ? null : this.customConverterMap.get(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegisterConverter register(Type type, Converter converter) {
        if (null == this.customConverterMap) {
            RegisterConverter registerConverter = this;
            synchronized (registerConverter) {
                if (null == this.customConverterMap) {
                    this.customConverterMap = new ConcurrentHashMap<Type, Converter>();
                }
            }
        }
        this.customConverterMap.put(type, converter);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegisterConverter register(MatcherConverter converter) {
        if (null == this.converterSet) {
            RegisterConverter registerConverter = this;
            synchronized (registerConverter) {
                if (null == this.converterSet) {
                    this.converterSet = new ConcurrentHashSet<MatcherConverter>();
                }
            }
        }
        this.converterSet.add(converter);
        return this;
    }
}

