/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.convert;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Map;
import org.miaixz.bus.core.convert.Converter;
import org.miaixz.bus.core.convert.ConverterWithRoot;
import org.miaixz.bus.core.lang.exception.ConvertException;
import org.miaixz.bus.core.lang.reflect.TypeReference;
import org.miaixz.bus.core.lang.tuple.Triplet;
import org.miaixz.bus.core.xyz.BeanKit;
import org.miaixz.bus.core.xyz.TypeKit;

public class TripletConverter
extends ConverterWithRoot
implements Serializable {
    private static final long serialVersionUID = 2852272275571L;

    public TripletConverter(Converter rootConverter) {
        super(rootConverter);
    }

    private Triplet<?, ?, ?> mapToTriple(Type leftType, Type middleType, Type rightType, Map map) {
        Object left = map.get("left");
        Object middle = map.get("middle");
        Object right = map.get("right");
        return Triplet.of(TypeKit.isUnknown(leftType) ? left : this.converter.convert(leftType, left), TypeKit.isUnknown(middleType) ? middle : this.converter.convert(middleType, middle), TypeKit.isUnknown(rightType) ? right : this.converter.convert(rightType, right));
    }

    @Override
    public Object convert(Type targetType, Object value) throws ConvertException {
        if (targetType instanceof TypeReference) {
            targetType = ((TypeReference)targetType).getType();
        }
        Type leftType = TypeKit.getTypeArgument(targetType, 0);
        Type middileType = TypeKit.getTypeArgument(targetType, 1);
        Type rightType = TypeKit.getTypeArgument(targetType, 2);
        return this.convert(leftType, middileType, rightType, value);
    }

    public Triplet<?, ?, ?> convert(Type leftType, Type middleType, Type rightType, Object value) throws ConvertException {
        Map<String, Object> map = null;
        if (value instanceof Map) {
            map = (Map<String, Object>)value;
        } else if (BeanKit.isReadableBean(value.getClass())) {
            map = BeanKit.toBeanMap(value);
        }
        if (null != map) {
            return this.mapToTriple(leftType, middleType, rightType, map);
        }
        throw new ConvertException("Unsupported to map from [{}] of type: {}", value, value.getClass().getName());
    }
}

