/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.data.id;

import java.io.Serializable;
import java.nio.ByteOrder;
import java.util.Objects;
import java.util.Random;
import org.miaixz.bus.core.codec.No128;
import org.miaixz.bus.core.codec.binary.Crockford;
import org.miaixz.bus.core.data.id.UUID;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.xyz.ByteKit;
import org.miaixz.bus.core.xyz.RandomKit;

public class ULID
implements Comparable<ULID>,
Serializable {
    private static final long serialVersionUID = 2852275998965L;
    private static final long TIMESTAMP_MASK = -281474976710656L;
    private static final int RANDOMNESS_BYTE_LEN = 10;
    private static final long OVERFLOW = 0L;
    private final No128 idValue;

    public ULID(No128 no128) {
        this.idValue = no128;
    }

    public static ULID of() {
        return ULID.of(System.currentTimeMillis());
    }

    public static ULID of(long timestamp) {
        return ULID.of(timestamp, RandomKit.getRandom());
    }

    public static ULID of(long timestamp, Random random) {
        return ULID.of(timestamp, RandomKit.randomBytes(10, random));
    }

    public static ULID of(long timestamp, byte[] randomness) {
        ULID.checkTimestamp(timestamp);
        Assert.notNull(randomness);
        Assert.isTrue(10 == randomness.length, "Invalid randomness", new Object[0]);
        long msb = 0L;
        msb |= timestamp << 16;
        msb |= (long)(randomness[0] & 0xFF) << 8;
        return new ULID(new No128(msb |= (long)(randomness[1] & 0xFF), ByteKit.toLong(randomness, 2, ByteOrder.BIG_ENDIAN)));
    }

    public static ULID of(String ulidString) {
        Objects.requireNonNull(ulidString, "ulidString must not be null!");
        if (ulidString.length() != 26) {
            throw new IllegalArgumentException("ulidString must be exactly 26 chars long.");
        }
        String timeString = ulidString.substring(0, 10);
        long time = Crockford.parseCrockford(timeString);
        ULID.checkTimestamp(time);
        String part1String = ulidString.substring(10, 18);
        String part2String = ulidString.substring(18);
        long part1 = Crockford.parseCrockford(part1String);
        long part2 = Crockford.parseCrockford(part2String);
        long most = time << 16 | part1 >>> 24;
        long least = part2 | part1 << 40;
        return new ULID(new No128(most, least));
    }

    public static ULID of(byte[] data) {
        int i;
        Objects.requireNonNull(data, "data must not be null!");
        if (data.length != 16) {
            throw new IllegalArgumentException("data must be 16 bytes in length!");
        }
        long mostSignificantBits = 0L;
        long leastSignificantBits = 0L;
        for (i = 0; i < 8; ++i) {
            mostSignificantBits = mostSignificantBits << 8 | (long)(data[i] & 0xFF);
        }
        for (i = 8; i < 16; ++i) {
            leastSignificantBits = leastSignificantBits << 8 | (long)(data[i] & 0xFF);
        }
        return new ULID(new No128(mostSignificantBits, leastSignificantBits));
    }

    private static void checkTimestamp(long timestamp) {
        Assert.isTrue((timestamp & 0xFFFF000000000000L) == 0L, "ULID does not support timestamps after +10889-08-02T05:31:50.655Z!", new Object[0]);
    }

    public long getMostSignificantBits() {
        return this.idValue.getMostSigBits();
    }

    public long getLeastSignificantBits() {
        return this.idValue.getLeastSigBits();
    }

    public long getTimestamp() {
        return this.idValue.getMostSigBits() >>> 16;
    }

    public byte[] getRandomness() {
        long msb = this.idValue.getMostSigBits();
        long lsb = this.idValue.getLeastSigBits();
        byte[] randomness = new byte[10];
        randomness[0] = (byte)(msb >>> 8);
        randomness[1] = (byte)msb;
        ByteKit.fill(lsb, 2, ByteOrder.BIG_ENDIAN, randomness);
        return randomness;
    }

    public ULID increment() {
        long msb = this.idValue.getMostSigBits();
        long lsb = this.idValue.getLeastSigBits();
        long newMsb = msb;
        long newLsb = lsb + 1L;
        if (newLsb == 0L) {
            ++newMsb;
        }
        return new ULID(new No128(newMsb, newLsb));
    }

    public ULID nextMonotonic(long timestamp) {
        if (this.getTimestamp() == timestamp) {
            return this.increment();
        }
        return ULID.of(timestamp);
    }

    public byte[] toBytes() {
        int i;
        long msb = this.idValue.getMostSigBits();
        long lsb = this.idValue.getLeastSigBits();
        byte[] result = new byte[16];
        for (i = 0; i < 8; ++i) {
            result[i] = (byte)(msb >> (7 - i) * 8 & 0xFFL);
        }
        for (i = 8; i < 16; ++i) {
            result[i] = (byte)(lsb >> (15 - i) * 8 & 0xFFL);
        }
        return result;
    }

    public UUID toUUID() {
        long msb = this.idValue.getMostSigBits();
        long lsb = this.idValue.getLeastSigBits();
        return new UUID(msb, lsb);
    }

    public java.util.UUID toJdkUUID() {
        long msb = this.idValue.getMostSigBits();
        long lsb = this.idValue.getLeastSigBits();
        return new java.util.UUID(msb, lsb);
    }

    @Override
    public int compareTo(ULID o) {
        return this.idValue.compareTo(o.idValue);
    }

    public boolean equals(Object object) {
        if (Objects.isNull(object) || object.getClass() != ULID.class) {
            return false;
        }
        ULID id = (ULID)object;
        return this.idValue.equals(id.idValue);
    }

    public int hashCode() {
        return this.idValue.hashCode();
    }

    public String toString() {
        long msb = this.idValue.getMostSigBits();
        long lsb = this.idValue.getLeastSigBits();
        char[] buffer = new char[26];
        Crockford.writeCrockford(buffer, this.getTimestamp(), 10, 0);
        long value = (msb & 0xFFFFL) << 24;
        long interim = lsb >>> 40;
        Crockford.writeCrockford(buffer, value |= interim, 8, 10);
        Crockford.writeCrockford(buffer, lsb, 8, 18);
        return new String(buffer);
    }
}

