/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.data.masking;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.miaixz.bus.core.data.masking.MaskingHandler;
import org.miaixz.bus.core.lang.EnumValue;
import org.miaixz.bus.core.xyz.StringKit;

public class MaskingManager {
    public static final MaskingManager EMPTY = new MaskingManager(null);
    private final Map<String, MaskingHandler> handlerMap;
    private final char maskChar;

    public MaskingManager(Map<String, MaskingHandler> handlerMap) {
        this(handlerMap, '*');
    }

    public MaskingManager(Map<String, MaskingHandler> handlerMap, char maskChar) {
        this.handlerMap = handlerMap;
        this.maskChar = maskChar;
    }

    public static MaskingManager getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public static MaskingManager ofDefault(char maskChar) {
        return MaskingManager.registerDefault(maskChar);
    }

    private static MaskingManager registerDefault(char maskChar) {
        MaskingManager manager = new MaskingManager(new ConcurrentHashMap<String, MaskingHandler>(15, 1.0f), maskChar);
        manager.register(EnumValue.Masking.USER_ID.name(), str -> "0");
        manager.register(EnumValue.Masking.CHINESE_NAME.name(), manager::firstMask);
        manager.register(EnumValue.Masking.ID_CARD.name(), str -> manager.idCardNum(str, 1, 2));
        manager.register(EnumValue.Masking.FIXED_PHONE.name(), manager::fixedPhone);
        manager.register(EnumValue.Masking.MOBILE_PHONE.name(), manager::mobilePhone);
        manager.register(EnumValue.Masking.ADDRESS.name(), str -> manager.address(str, 8));
        manager.register(EnumValue.Masking.EMAIL.name(), manager::email);
        manager.register(EnumValue.Masking.PASSWORD.name(), manager::password);
        manager.register(EnumValue.Masking.CAR_LICENSE.name(), manager::carLicense);
        manager.register(EnumValue.Masking.BANK_CARD.name(), manager::bankCard);
        manager.register(EnumValue.Masking.IPV4.name(), manager::ipv4);
        manager.register(EnumValue.Masking.IPV6.name(), manager::ipv6);
        manager.register(EnumValue.Masking.FIRST_MASK.name(), manager::firstMask);
        manager.register(EnumValue.Masking.CLEAR_TO_EMPTY.name(), str -> "");
        manager.register(EnumValue.Masking.CLEAR_TO_NULL.name(), str -> null);
        return manager;
    }

    public MaskingManager register(String type, MaskingHandler handler) {
        this.handlerMap.put(type, handler);
        return this;
    }

    public String masking(String type, CharSequence value) {
        MaskingHandler handler;
        if (StringKit.isEmpty(type)) {
            type = EnumValue.Masking.CLEAR_TO_NULL.name();
        }
        return null == (handler = this.handlerMap.get(type)) ? null : handler.handle(value);
    }

    public String firstMask(CharSequence str) {
        if (StringKit.isBlank(str)) {
            return "";
        }
        return StringKit.replaceByCodePoint(str, 1, str.length(), this.maskChar);
    }

    public String idCardNum(CharSequence idCardNum, int front, int end) {
        if (StringKit.isBlank(idCardNum)) {
            return "";
        }
        if (front + end > idCardNum.length()) {
            return "";
        }
        if (front < 0 || end < 0) {
            return "";
        }
        return StringKit.replaceByCodePoint(idCardNum, front, idCardNum.length() - end, this.maskChar);
    }

    public String fixedPhone(CharSequence num) {
        if (StringKit.isBlank(num)) {
            return "";
        }
        return StringKit.replaceByCodePoint(num, 4, num.length() - 2, this.maskChar);
    }

    public String mobilePhone(CharSequence num) {
        if (StringKit.isBlank(num)) {
            return "";
        }
        return StringKit.replaceByCodePoint(num, 3, num.length() - 4, this.maskChar);
    }

    public String address(CharSequence address, int sensitiveSize) {
        if (StringKit.isBlank(address)) {
            return "";
        }
        int length = address.length();
        return StringKit.replaceByCodePoint(address, length - sensitiveSize, length, this.maskChar);
    }

    public String email(CharSequence email) {
        if (StringKit.isBlank(email)) {
            return "";
        }
        int index = StringKit.indexOf(email, '@');
        if (index <= 1) {
            return email.toString();
        }
        return StringKit.replaceByCodePoint(email, 1, index, this.maskChar);
    }

    public String password(CharSequence password) {
        if (StringKit.isBlank(password)) {
            return "";
        }
        return StringKit.repeat(this.maskChar, 10);
    }

    public String carLicense(CharSequence carLicense) {
        if (StringKit.isBlank(carLicense)) {
            return "";
        }
        if (carLicense.length() == 7) {
            carLicense = StringKit.replaceByCodePoint(carLicense, 3, 6, this.maskChar);
        } else if (carLicense.length() == 8) {
            carLicense = StringKit.replaceByCodePoint(carLicense, 3, 7, this.maskChar);
        }
        return carLicense.toString();
    }

    public String bankCard(CharSequence bankCardNo) {
        if (StringKit.isBlank(bankCardNo)) {
            return StringKit.toStringOrNull(bankCardNo);
        }
        if ((bankCardNo = StringKit.cleanBlank(bankCardNo)).length() < 9) {
            return bankCardNo.toString();
        }
        int length = bankCardNo.length();
        int endLength = length % 4 == 0 ? 4 : length % 4;
        int midLength = length - 4 - endLength;
        StringBuilder buf = new StringBuilder();
        buf.append(bankCardNo, 0, 4);
        for (int i = 0; i < midLength; ++i) {
            if (i % 4 == 0) {
                buf.append(' ');
            }
            buf.append(this.maskChar);
        }
        buf.append(' ').append(bankCardNo, length - endLength, length);
        return buf.toString();
    }

    public String ipv4(CharSequence ipv4) {
        return StringKit.subBefore(ipv4, '.', false) + StringKit.repeat("." + this.maskChar, 3);
    }

    public String ipv6(CharSequence ipv6) {
        return StringKit.subBefore(ipv6, ':', false) + StringKit.repeat(":" + this.maskChar, 7);
    }

    private static class SingletonHolder {
        private static final MaskingManager INSTANCE = MaskingManager.registerDefault('*');

        private SingletonHolder() {
        }
    }
}

