/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.io;

import java.io.Reader;
import java.util.Objects;
import org.miaixz.bus.core.lang.Assert;

public class CharSequenceReader
extends Reader {
    private final int start;
    private final int end;
    private final CharSequence text;
    private int next;
    private int mark;

    public CharSequenceReader(CharSequence text, int startInclude, int endExclude) {
        Assert.isTrue(startInclude >= 0, "Start index is less than zero: {}", startInclude);
        Assert.isTrue(endExclude > startInclude, "End index is less than start {}: {}", startInclude, endExclude);
        if (null == text) {
            text = "";
        }
        this.text = text;
        int length = text.length();
        this.start = Math.min(length, startInclude);
        this.end = Math.min(length, endExclude);
        this.next = startInclude;
        this.mark = startInclude;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readAheadLimit) {
        this.mark = this.next;
    }

    @Override
    public void reset() {
        this.next = this.mark;
    }

    @Override
    public int read() {
        if (this.next >= this.end) {
            return -1;
        }
        return this.text.charAt(this.next++);
    }

    @Override
    public int read(char[] array, int offset, int length) {
        if (this.next >= this.end) {
            return -1;
        }
        Objects.requireNonNull(array, "array");
        if (length < 0 || offset < 0 || offset + length > array.length) {
            throw new IndexOutOfBoundsException("Array Size=" + array.length + ", offset=" + offset + ", length=" + length);
        }
        if (this.text instanceof String) {
            int count = Math.min(length, this.end - this.next);
            ((String)this.text).getChars(this.next, this.next + count, array, offset);
            this.next += count;
            return count;
        }
        if (this.text instanceof StringBuilder) {
            int count = Math.min(length, this.end - this.next);
            ((StringBuilder)this.text).getChars(this.next, this.next + count, array, offset);
            this.next += count;
            return count;
        }
        if (this.text instanceof StringBuffer) {
            int count = Math.min(length, this.end - this.next);
            ((StringBuffer)this.text).getChars(this.next, this.next + count, array, offset);
            this.next += count;
            return count;
        }
        int count = 0;
        for (int i = 0; i < length; ++i) {
            int c = this.read();
            if (c == -1) {
                return count;
            }
            array[offset + i] = (char)c;
            ++count;
        }
        return count;
    }

    @Override
    public long skip(long n) {
        if (n < 0L) {
            throw new IllegalArgumentException("Number of characters to skip is less than zero: " + n);
        }
        if (this.next >= this.end) {
            return 0L;
        }
        int dest = (int)Math.min((long)this.end, (long)this.next + n);
        int count = dest - this.next;
        this.next = dest;
        return count;
    }

    @Override
    public boolean ready() {
        return this.next < this.end;
    }

    @Override
    public void close() {
        this.next = this.start;
        this.mark = this.start;
    }

    public String toString() {
        return this.text.subSequence(this.start, this.end).toString();
    }
}

