/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.io;

import org.miaixz.bus.core.io.LifeCycle;

public class SectionBuffer {
    public static final int SIZE = 8192;
    public static final int SHARE_MINIMUM = 2048;
    public final byte[] data;
    public int pos;
    public int limit;
    public boolean shared;
    public boolean owner;
    public SectionBuffer next;
    public SectionBuffer prev;

    public SectionBuffer() {
        this.data = new byte[8192];
        this.owner = true;
        this.shared = false;
    }

    public SectionBuffer(byte[] data, int pos, int limit, boolean shared, boolean owner) {
        this.data = data;
        this.pos = pos;
        this.limit = limit;
        this.shared = shared;
        this.owner = owner;
    }

    public final SectionBuffer sharedCopy() {
        this.shared = true;
        return new SectionBuffer(this.data, this.pos, this.limit, true, false);
    }

    public final SectionBuffer unsharedCopy() {
        return new SectionBuffer((byte[])this.data.clone(), this.pos, this.limit, false, true);
    }

    public final SectionBuffer pop() {
        SectionBuffer result = this.next != this ? this.next : null;
        this.prev.next = this.next;
        this.next.prev = this.prev;
        this.next = null;
        this.prev = null;
        return result;
    }

    public final SectionBuffer push(SectionBuffer segment) {
        segment.prev = this;
        segment.next = this.next;
        this.next.prev = segment;
        this.next = segment;
        return segment;
    }

    public final SectionBuffer split(int byteCount) {
        SectionBuffer prefix;
        if (byteCount <= 0 || byteCount > this.limit - this.pos) {
            throw new IllegalArgumentException();
        }
        if (byteCount >= 2048) {
            prefix = this.sharedCopy();
        } else {
            prefix = LifeCycle.take();
            System.arraycopy(this.data, this.pos, prefix.data, 0, byteCount);
        }
        prefix.limit = prefix.pos + byteCount;
        this.pos += byteCount;
        this.prev.push(prefix);
        return prefix;
    }

    public void compact() {
        if (this.prev == this) {
            throw new IllegalStateException();
        }
        if (!this.prev.owner) {
            return;
        }
        int byteCount = this.limit - this.pos;
        int availableByteCount = 8192 - this.prev.limit + (this.prev.shared ? 0 : this.prev.pos);
        if (byteCount > availableByteCount) {
            return;
        }
        this.writeTo(this.prev, byteCount);
        this.pop();
        LifeCycle.recycle(this);
    }

    public final void writeTo(SectionBuffer sink, int byteCount) {
        if (!sink.owner) {
            throw new IllegalArgumentException();
        }
        if (sink.limit + byteCount > 8192) {
            if (sink.shared) {
                throw new IllegalArgumentException();
            }
            if (sink.limit + byteCount - sink.pos > 8192) {
                throw new IllegalArgumentException();
            }
            System.arraycopy(sink.data, sink.pos, sink.data, 0, sink.limit - sink.pos);
            sink.limit -= sink.pos;
            sink.pos = 0;
        }
        System.arraycopy(this.data, this.pos, sink.data, sink.limit, byteCount);
        sink.limit += byteCount;
        this.pos += byteCount;
    }
}

