/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.io.check.crc16;

import java.io.Serializable;
import java.util.zip.Checksum;
import org.miaixz.bus.core.xyz.HexKit;
import org.miaixz.bus.core.xyz.StringKit;

public abstract class CRC16Checksum
implements Checksum,
Serializable {
    private static final long serialVersionUID = 2852278688761L;
    protected int wCRCin;

    public CRC16Checksum() {
        this.reset();
    }

    @Override
    public long getValue() {
        return this.wCRCin;
    }

    public String getHexValue() {
        return this.getHexValue(false);
    }

    public String getHexValue(boolean isPadding) {
        String hex = HexKit.toHex(this.getValue());
        if (isPadding) {
            hex = StringKit.padPre((CharSequence)hex, 4, '0');
        }
        return hex;
    }

    @Override
    public void reset() {
        this.wCRCin = 0;
    }

    @Override
    public void update(byte[] b) {
        this.update(b, 0, b.length);
    }

    @Override
    public void update(byte[] b, int off, int len) {
        for (int i = off; i < off + len; ++i) {
            this.update(b[i]);
        }
    }
}

