/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.io.compress;

import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.miaixz.bus.core.io.resource.Resource;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.FileKit;
import org.miaixz.bus.core.xyz.IoKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.core.xyz.ZipKit;

public class ZipWriter
implements Closeable {
    private final ZipOutputStream out;
    private File zipFile;
    private int bufferSize = 8192;

    public ZipWriter(File zipFile, Charset charset) {
        this(ZipWriter.getZipOutputStream(zipFile, charset));
        this.zipFile = zipFile;
    }

    public ZipWriter(OutputStream out, Charset charset) {
        this(ZipKit.getZipOutputStream(out, charset));
    }

    public ZipWriter(ZipOutputStream out) {
        this.out = out;
    }

    public static ZipWriter of(File zipFile, Charset charset) {
        return new ZipWriter(zipFile, charset);
    }

    public static ZipWriter of(OutputStream out, Charset charset) {
        return new ZipWriter(out, charset);
    }

    private static ZipOutputStream getZipOutputStream(File zipFile, Charset charset) {
        return ZipKit.getZipOutputStream(FileKit.getOutputStream(zipFile, new OpenOption[0]), charset);
    }

    public ZipWriter setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
        return this;
    }

    public ZipWriter setLevel(int level) {
        this.out.setLevel(level);
        return this;
    }

    public ZipWriter setComment(String comment) {
        this.out.setComment(comment);
        return this;
    }

    public ZipWriter setMethod(int method) {
        this.out.setMethod(method);
        return this;
    }

    public ZipOutputStream getOut() {
        return this.out;
    }

    public ZipWriter add(boolean withSrcDir, FileFilter filter, File ... files) throws InternalException {
        for (File file : files) {
            String srcRootDir;
            try {
                srcRootDir = file.getCanonicalPath();
                if (!file.isDirectory() || withSrcDir) {
                    srcRootDir = file.getCanonicalFile().getParentFile().getCanonicalPath();
                }
            }
            catch (IOException e) {
                throw new InternalException(e);
            }
            this._add(file, srcRootDir, filter);
        }
        return this;
    }

    public ZipWriter add(Resource ... resources) throws InternalException {
        for (Resource resource : resources) {
            if (null == resource) continue;
            this.add(resource.getName(), resource.getStream());
        }
        return this;
    }

    public ZipWriter add(String path, InputStream in) throws InternalException {
        path = StringKit.toStringOrEmpty(path);
        if (null == in && StringKit.isBlank(path = StringKit.addSuffixIfNot(path, "/"))) {
            return this;
        }
        return this.putEntry(path, in);
    }

    public ZipWriter add(String[] paths, InputStream[] ins) throws InternalException {
        if (ArrayKit.isEmpty(paths) || ArrayKit.isEmpty(ins)) {
            throw new IllegalArgumentException("Paths or ins is empty !");
        }
        if (paths.length != ins.length) {
            throw new IllegalArgumentException("Paths length is not equals to ins length !");
        }
        for (int i = 0; i < paths.length; ++i) {
            this.add(paths[i], ins[i]);
        }
        return this;
    }

    @Override
    public void close() throws InternalException {
        try {
            this.out.finish();
        }
        catch (IOException e) {
            try {
                throw new InternalException(e);
            }
            catch (Throwable throwable) {
                IoKit.closeQuietly(this.out);
                throw throwable;
            }
        }
        IoKit.closeQuietly(this.out);
    }

    private void _add(File file, String srcRootDir, FileFilter filter) throws InternalException {
        if (null == file || null != filter && !filter.accept(file)) {
            return;
        }
        String subPath = FileKit.subPath(srcRootDir, file);
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (ArrayKit.isEmpty(files)) {
                this.add(subPath, null);
            } else {
                for (File childFile : files) {
                    this._add(childFile, srcRootDir, filter);
                }
            }
        } else {
            if (FileKit.equals(file, this.zipFile)) {
                return;
            }
            this.putEntry(subPath, FileKit.getInputStream(file));
        }
    }

    private ZipWriter putEntry(String path, InputStream in) throws InternalException {
        ZipEntry entry = new ZipEntry(path);
        ZipOutputStream out = this.out;
        try {
            out.putNextEntry(entry);
            if (null != in) {
                IoKit.copy(in, (OutputStream)out, this.bufferSize);
            }
            out.closeEntry();
        }
        catch (IOException e) {
            try {
                throw new InternalException(e);
            }
            catch (Throwable throwable) {
                IoKit.closeQuietly(in);
                throw throwable;
            }
        }
        IoKit.closeQuietly(in);
        IoKit.flush(out);
        return this;
    }
}

