/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.io.file;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import org.miaixz.bus.core.center.function.ConsumerX;
import org.miaixz.bus.core.io.watch.SimpleWatcher;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.FileKit;

public class LineWatcher
extends SimpleWatcher
implements Runnable {
    private final RandomAccessFile randomAccessFile;
    private final Charset charset;
    private final ConsumerX<String> lineHandler;

    public LineWatcher(RandomAccessFile randomAccessFile, Charset charset, ConsumerX<String> lineHandler) {
        this.randomAccessFile = randomAccessFile;
        this.charset = charset;
        this.lineHandler = lineHandler;
    }

    @Override
    public void run() {
        this.onModify(null, null);
    }

    @Override
    public void onModify(WatchEvent<?> event, WatchKey key) {
        RandomAccessFile randomAccessFile = this.randomAccessFile;
        Charset charset = this.charset;
        ConsumerX<String> lineHandler = this.lineHandler;
        try {
            long currentLength = randomAccessFile.length();
            long position = randomAccessFile.getFilePointer();
            if (position == currentLength) {
                return;
            }
            if (currentLength < position) {
                randomAccessFile.seek(currentLength);
                return;
            }
            FileKit.readLines(randomAccessFile, charset, lineHandler);
            randomAccessFile.seek(currentLength);
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }
}

