/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.io.resource;

import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.jar.JarFile;
import org.miaixz.bus.core.io.resource.UrlResource;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.ZipKit;

public class JarResource
extends UrlResource {
    private static final long serialVersionUID = 2852231952129L;

    public JarResource(URI uri) {
        super(uri);
    }

    public JarResource(URL url) {
        super(url);
    }

    public JarResource(URL url, String name) {
        super(url, name);
    }

    public JarFile getJarFile() throws InternalException {
        try {
            return this.doGetJarFile();
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    private JarFile doGetJarFile() throws IOException {
        URLConnection con = this.getUrl().openConnection();
        if (con instanceof JarURLConnection) {
            JarURLConnection jarCon = (JarURLConnection)con;
            return jarCon.getJarFile();
        }
        String urlFile = this.getUrl().getFile();
        int separatorIndex = urlFile.indexOf("*/");
        if (separatorIndex == -1) {
            separatorIndex = urlFile.indexOf("!/");
        }
        if (separatorIndex != -1) {
            return ZipKit.ofJar(urlFile.substring(0, separatorIndex));
        }
        return new JarFile(urlFile);
    }
}

