/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.io.resource;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import org.miaixz.bus.core.io.resource.Resource;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.ListKit;

public class MultiResource
implements Resource,
Iterable<Resource>,
Iterator<Resource>,
Serializable {
    private static final long serialVersionUID = 2852232202695L;
    private final List<Resource> resources;
    private int cursor;

    public MultiResource(Resource ... resources) {
        this(ListKit.of(resources));
    }

    public MultiResource(Collection<Resource> resources) {
        this.resources = resources instanceof List ? (List<Object>)resources : ListKit.of(resources);
    }

    @Override
    public String getName() {
        return this.resources.get(this.cursor).getName();
    }

    @Override
    public URL getUrl() {
        return this.resources.get(this.cursor).getUrl();
    }

    @Override
    public long size() {
        return this.resources.get(this.cursor).size();
    }

    @Override
    public InputStream getStream() {
        return this.resources.get(this.cursor).getStream();
    }

    @Override
    public boolean isModified() {
        return this.resources.get(this.cursor).isModified();
    }

    @Override
    public BufferedReader getReader(Charset charset) {
        return this.resources.get(this.cursor).getReader(charset);
    }

    @Override
    public String readString(Charset charset) throws InternalException {
        return this.resources.get(this.cursor).readString(charset);
    }

    @Override
    public String readString() throws InternalException {
        return this.resources.get(this.cursor).readString();
    }

    @Override
    public byte[] readBytes() throws InternalException {
        return this.resources.get(this.cursor).readBytes();
    }

    @Override
    public Iterator<Resource> iterator() {
        return this.resources.iterator();
    }

    @Override
    public boolean hasNext() {
        return this.cursor < this.resources.size();
    }

    @Override
    public synchronized Resource next() {
        if (this.cursor >= this.resources.size()) {
            throw new ConcurrentModificationException();
        }
        ++this.cursor;
        return this;
    }

    @Override
    public void remove() {
        this.resources.remove(this.cursor);
    }

    public synchronized void reset() {
        this.cursor = 0;
    }

    public MultiResource add(Resource resource) {
        this.resources.add(resource);
        return this;
    }

    public MultiResource addAll(Iterable<? extends Resource> iterable) {
        iterable.forEach(this::add);
        return this;
    }
}

