/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.io.resource;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import org.miaixz.bus.core.io.file.FileName;
import org.miaixz.bus.core.io.resource.Resource;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.FileKit;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.core.xyz.UrlKit;

public class UrlResource
implements Resource,
Serializable {
    private static final long serialVersionUID = 2852232772701L;
    protected URL url;
    protected String name;
    private long lastModified = 0L;

    public UrlResource(URI uri) {
        this(UrlKit.url(uri), null);
    }

    public UrlResource(URL url) {
        this(url, null);
    }

    public UrlResource(URL url, String name) {
        this.url = url;
        if (null != url && "file".equals(url.getProtocol())) {
            this.lastModified = FileKit.file(url).lastModified();
        }
        this.name = ObjectKit.defaultIfNull(name, () -> null != url ? FileName.getName(url.getPath()) : null);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    @Override
    public long size() {
        return UrlKit.size(this.url);
    }

    @Override
    public InputStream getStream() throws InternalException {
        if (null == this.url) {
            throw new InternalException("Resource URL is null!");
        }
        return UrlKit.getStream(this.url);
    }

    @Override
    public boolean isModified() {
        return 0L != this.lastModified && this.lastModified != this.getFile().lastModified();
    }

    public File getFile() {
        return FileKit.file(this.url);
    }

    public String toString() {
        return null == this.url ? "null" : this.url.toString();
    }

    public UrlResource createRelative(String relativePath) {
        return new UrlResource(UrlKit.getURL(this.getUrl(), relativePath));
    }
}

