/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.io.stream;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import org.miaixz.bus.core.io.ByteOrderMark;
import org.miaixz.bus.core.lang.exception.InternalException;

public class BOMInputStream
extends InputStream {
    private static final int BOM_SIZE = 4;
    private final PushbackInputStream in;
    private final String defaultCharset;
    private boolean initialized = false;
    private String charset;

    public BOMInputStream(InputStream in) {
        this(in, "UTF-8");
    }

    public BOMInputStream(InputStream in, String defaultCharset) {
        this.in = new PushbackInputStream(in, 4);
        this.defaultCharset = defaultCharset;
    }

    public String getDefaultCharset() {
        return this.defaultCharset;
    }

    public String getCharset() {
        if (!this.initialized) {
            try {
                this.init();
            }
            catch (IOException ex) {
                throw new InternalException(ex);
            }
        }
        return this.charset;
    }

    @Override
    public void close() throws IOException {
        this.initialized = true;
        this.in.close();
    }

    @Override
    public int read() throws IOException {
        this.initialized = true;
        return this.in.read();
    }

    protected void init() throws IOException {
        if (this.initialized) {
            return;
        }
        byte[] bom = new byte[4];
        int unread = 0;
        int n = this.in.read(bom, 0, bom.length);
        for (ByteOrderMark byteOrderMark : ByteOrderMark.ALL) {
            if (!byteOrderMark.test(bom)) continue;
            this.charset = byteOrderMark.getCharsetName();
            unread = n - byteOrderMark.length();
            break;
        }
        if (0 == unread) {
            this.charset = this.defaultCharset;
            unread = n;
        }
        if (unread > 0) {
            this.in.unread(bom, n - unread, unread);
        }
        this.initialized = true;
    }
}

