/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.io.stream;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.miaixz.bus.core.io.buffer.FastByteBuffer;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.IoKit;
import org.miaixz.bus.core.xyz.ObjectKit;

public class FastByteArrayOutputStream
extends OutputStream {
    private final FastByteBuffer buffer;

    public FastByteArrayOutputStream() {
        this(2048);
    }

    public FastByteArrayOutputStream(int size) {
        this.buffer = new FastByteBuffer(size);
    }

    public static FastByteArrayOutputStream of(InputStream in, int limit) {
        int length = IoKit.length(in);
        if (length < 0 || length > limit) {
            length = limit;
        }
        if (length < 0) {
            length = 2048;
        }
        return new FastByteArrayOutputStream(length);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        this.buffer.append(b, off, len);
    }

    @Override
    public void write(int b) {
        this.buffer.append((byte)b);
    }

    public int size() {
        return this.buffer.length();
    }

    @Override
    public void close() {
    }

    public void reset() {
        this.buffer.reset();
    }

    public void writeTo(OutputStream out) throws InternalException {
        int index = this.buffer.index();
        if (index < 0) {
            return;
        }
        try {
            for (int i = 0; i < index; ++i) {
                byte[] buf = this.buffer.array(i);
                out.write(buf);
            }
            out.write(this.buffer.array(index), 0, this.buffer.offset());
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    public byte[] toByteArray() {
        return this.buffer.toArray();
    }

    public byte[] toByteArray(int start, int len) {
        return this.buffer.toArray(start, len);
    }

    public byte[] toByteArrayZeroCopyIfPossible() {
        return this.buffer.toArrayZeroCopyIfPossible();
    }

    public byte get(int index) {
        return this.buffer.get(index);
    }

    public String toString() {
        return this.toString(org.miaixz.bus.core.lang.Charset.defaultCharset());
    }

    public String toString(Charset charset) {
        return new String(this.toByteArray(), ObjectKit.defaultIfNull(charset, org.miaixz.bus.core.lang.Charset::defaultCharset));
    }
}

