/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.io.stream;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.miaixz.bus.core.lang.exception.InternalException;

public class LineCounter
implements Closeable {
    private final InputStream is;
    private final int bufferSize;
    private boolean lastLineSeparatorAsNewLine = true;
    private int count = -1;

    public LineCounter(InputStream is, int bufferSize) {
        this.is = is;
        this.bufferSize = bufferSize < 1 ? 1024 : bufferSize;
    }

    public LineCounter setLastLineSeparatorAsNewLine(boolean lastLineSeparatorAsNewLine) {
        this.lastLineSeparatorAsNewLine = lastLineSeparatorAsNewLine;
        return this;
    }

    public int getCount() {
        if (this.count < 0) {
            try {
                this.count = this.count();
            }
            catch (IOException e) {
                throw new InternalException(e);
            }
        }
        return this.count;
    }

    @Override
    public void close() throws IOException {
        if (null != this.is) {
            this.is.close();
        }
    }

    private int count() throws IOException {
        int pre;
        int i;
        byte[] buf = new byte[this.bufferSize];
        int readChars = this.is.read(buf);
        if (readChars == -1) {
            return 0;
        }
        int count = 1;
        int c = 0;
        while (readChars == this.bufferSize) {
            for (i = 0; i < this.bufferSize; ++i) {
                pre = c;
                c = buf[i];
                if (c != 10 && pre != 13) continue;
                ++count;
            }
            readChars = this.is.read(buf);
        }
        while (readChars != -1) {
            for (i = 0; i < readChars; ++i) {
                pre = c;
                c = buf[i];
                if (c != 10 && pre != 13) continue;
                ++count;
            }
            readChars = this.is.read(buf);
        }
        if (this.lastLineSeparatorAsNewLine) {
            if (c == 13) {
                ++count;
            }
        } else if (c == 10) {
            --count;
        }
        return count;
    }
}

