/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.io.stream;

import java.io.IOException;
import java.io.InputStream;
import java.util.function.Predicate;
import org.miaixz.bus.core.io.stream.FastByteArrayOutputStream;
import org.miaixz.bus.core.io.stream.ValidateObjectInputStream;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.IoKit;

public class StreamReader {
    private final InputStream in;
    private final boolean closeAfterRead;

    public StreamReader(InputStream in, boolean closeAfterRead) {
        this.in = in;
        this.closeAfterRead = closeAfterRead;
    }

    public static StreamReader of(InputStream in, boolean closeAfterRead) {
        return new StreamReader(in, closeAfterRead);
    }

    public byte[] readBytes() throws InternalException {
        return this.readBytes(-1);
    }

    public byte[] readBytes(int length) throws InternalException {
        InputStream in = this.in;
        if (null == in || length == 0) {
            return new byte[0];
        }
        return this.read(length).toByteArrayZeroCopyIfPossible();
    }

    public FastByteArrayOutputStream read() throws InternalException {
        return this.read(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FastByteArrayOutputStream read(int limit) throws InternalException {
        InputStream in = this.in;
        FastByteArrayOutputStream out = FastByteArrayOutputStream.of(in, limit);
        try {
            IoKit.copyNio(in, out, 8192, limit, null);
            if (!this.closeAfterRead) return out;
        }
        catch (Throwable throwable) {
            if (!this.closeAfterRead) throw throwable;
            IoKit.closeQuietly(in);
            throw throwable;
        }
        IoKit.closeQuietly(in);
        return out;
    }

    public FastByteArrayOutputStream readTo(Predicate<Integer> predicate) throws InternalException {
        InputStream in = this.in;
        FastByteArrayOutputStream out = FastByteArrayOutputStream.of(in, -1);
        try {
            int read;
            while (!((read = in.read()) <= 0 || null != predicate && predicate.test(read))) {
                out.write(read);
            }
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
        return out;
    }

    public <T> T readObject(Class<?> ... acceptClasses) throws InternalException {
        ValidateObjectInputStream validateIn;
        InputStream in = this.in;
        if (null == in) {
            return null;
        }
        if (in instanceof ValidateObjectInputStream) {
            validateIn = (ValidateObjectInputStream)in;
            validateIn.accept(acceptClasses);
        } else {
            try {
                validateIn = new ValidateObjectInputStream(in, acceptClasses);
            }
            catch (IOException e) {
                throw new InternalException(e);
            }
        }
        try {
            return (T)validateIn.readObject();
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
        catch (ClassNotFoundException e) {
            throw new InternalException(e);
        }
    }
}

