/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.lang;

import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.miaixz.bus.core.xyz.MapKit;

public class MediaType {
    public static final String CHARSET_PARAMETER = "charset";
    public static final String MEDIA_TYPE_WILDCARD = "*";
    public static final String WILDCARD = "*/*";
    public static final MediaType WILDCARD_TYPE = new MediaType();
    public static final String APPLICATION_XML = "application/xml";
    public static final MediaType APPLICATION_XML_TYPE = new MediaType("application", "xml");
    public static final String APPLICATION_X_PROTOBUF = "application/x-protobuf";
    public static final MediaType APPLICATION_X_PROTOBUF_TYPE = new MediaType("application", "x-protobuf");
    public static final String MULTIPART_MIXED = "multipart/mixed";
    public static final MediaType MULTIPART_MIXED_TYPE = new MediaType("multipart", "mixed");
    public static final String MULTIPART_ALTERNATIVE = "multipart/alternative";
    public static final MediaType MULTIPART_ALTERNATIVE_TYPE = new MediaType("multipart", "alternative");
    public static final String MULTIPART_DIGEST = "multipart/digest";
    public static final MediaType MULTIPART_DIGEST_TYPE = new MediaType("multipart", "digest");
    public static final String MULTIPART_PARALLEL = "multipart/parallel";
    public static final MediaType MULTIPART_PARALLEL_TYPE = new MediaType("multipart", "parallel");
    public static final String APPLICATION_ATOM_XML = "application/atom+xml";
    public static final MediaType APPLICATION_ATOM_XML_TYPE = new MediaType("application", "atom+xml");
    public static final String APPLICATION_XHTML_XML = "application/xhtml+xml";
    public static final MediaType APPLICATION_XHTML_XML_TYPE = new MediaType("application", "xhtml+xml");
    public static final String APPLICATION_SVG_XML = "application/svg+xml";
    public static final MediaType APPLICATION_SVG_XML_TYPE = new MediaType("application", "svg+xml");
    public static final String APPLICATION_JSON = "application/json";
    public static final MediaType APPLICATION_JSON_TYPE = new MediaType("application", "json");
    public static final String APPLICATION_FORM_URLENCODED = "application/x-www-form-urlencoded";
    public static final MediaType APPLICATION_FORM_URLENCODED_TYPE = new MediaType("application", "x-www-form-urlencoded");
    public static final String MULTIPART_FORM_DATA = "multipart/form-data";
    public static final MediaType MULTIPART_FORM_DATA_TYPE = new MediaType("multipart", "form-data");
    public static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    public static final MediaType APPLICATION_OCTET_STREAM_TYPE = new MediaType("application", "octet-stream");
    public static final String TEXT_PLAIN = "text/plain";
    public static final MediaType TEXT_PLAIN_TYPE = new MediaType("text", "plain");
    public static final String TEXT_XML = "text/xml";
    public static final MediaType TEXT_XML_TYPE = new MediaType("text", "xml");
    public static final String TEXT_HTML = "text/html";
    public static final MediaType TEXT_HTML_TYPE = new MediaType("text", "html");
    public static final String SERVER_SENT_EVENTS = "text/event-stream";
    public static final MediaType SERVER_SENT_EVENTS_TYPE = new MediaType("text", "event-stream");
    public static final String APPLICATION_JSON_PATCH_JSON = "application/json-patch+json";
    public static final MediaType APPLICATION_JSON_PATCH_JSON_TYPE = new MediaType("application", "json-patch+json");
    public static final String APPLICATION_SOAP_XML = "application/soap+xml";
    public static final MediaType APPLICATION_SOAP_XML_TYPE = new MediaType("application", "soap+xml");
    public static final String APPLICATION_DICOM = "application/dicom";
    public static final MediaType APPLICATION_DICOM_TYPE = new MediaType("application", "dicom");
    public static final String APPLICATION_DICOM_XML = "application/dicom+xml";
    public static final MediaType APPLICATION_DICOM_XML_TYPE = new MediaType("application", "dicom+xml");
    public static final String APPLICATION_DICOM_JSON = "application/dicom+json";
    public static final MediaType APPLICATION_DICOM_JSON_TYPE = new MediaType("application", "dicom+json");
    public static final String IMAGE_WILDCARD = "image/*";
    public static final MediaType IMAGE_WILDCARD_TYPE = new MediaType("image", "*");
    public static final String IMAGE_GIF = "image/gif";
    public static final MediaType IMAGE_GIF_TYPE = new MediaType("image", "gif");
    public static final String IMAGE_PNG = "image/png";
    public static final MediaType IMAGE_PNG_TYPE = new MediaType("image", "png");
    public static final String IMAGE_JPEG = "image/jpeg";
    public static final MediaType IMAGE_JPEG_TYPE = new MediaType("image", "jpeg");
    public static final String IMAGE_JLS = "image/jls";
    public static final MediaType IMAGE_JLS_TYPE = new MediaType("image", "jls");
    public static final String IMAGE_JP2 = "image/jp2";
    public static final MediaType IMAGE_JP2_TYPE = new MediaType("image", "jp2");
    public static final String IMAGE_J2C = "image/j2c";
    public static final MediaType IMAGE_J2C_TYPE = new MediaType("image", "j2c");
    public static final String IMAGE_JPX = "image/jpx";
    public static final MediaType IMAGE_JPX_TYPE = new MediaType("image", "jpx");
    public static final String IMAGE_JPH = "image/jph";
    public static final MediaType IMAGE_JPH_TYPE = new MediaType("image", "jph");
    public static final String IMAGE_JPHC = "image/jphc";
    public static final MediaType IMAGE_JPHC_TYPE = new MediaType("image", "jphc");
    public static final String IMAGE_DICOM_RLE = "image/dicom-rle";
    public static final MediaType IMAGE_DICOM_RLE_TYPE = new MediaType("image", "dicom-rle");
    public static final String VIDEO_WILDCARD = "video/*";
    public static final MediaType VIDEO_WILDCARD_TYPE = new MediaType("video", "*");
    public static final String VIDEO_MPEG = "video/mpeg";
    public static final MediaType VIDEO_MPEG_TYPE = new MediaType("video", "mpeg");
    public static final String VIDEO_MP4 = "video/mp4";
    public static final MediaType VIDEO_MP4_TYPE = new MediaType("video", "mp4");
    public static final String VIDEO_QUICKTIME = "video/quicktime";
    public static final MediaType VIDEO_QUICKTIME_TYPE = new MediaType("video", "quicktime");
    public static final String APPLICATION_PDF = "application/pdf";
    public static final MediaType APPLICATION_PDF_TYPE = new MediaType("application", "pdf");
    public static final String TEXT_RTF = "text/rtf";
    public static final MediaType TEXT_RTF_TYPE = new MediaType("text", "rtf");
    public static final String TEXT_CSV = "text/csv";
    public static final MediaType TEXT_CSV_TYPE = new MediaType("text", "csv");
    public static final String TEXT_CSV_UTF8 = "text/csv;charset=utf-8";
    public static final MediaType TEXT_CSV_UTF8_TYPE = new MediaType("text", "csv", "utf-8");
    public static final String APPLICATION_ZIP = "application/zip";
    public static final MediaType APPLICATION_ZIP_TYPE = new MediaType("application", "zip");
    public static final String MULTIPART_RELATED = "multipart/related";
    public static final MediaType MULTIPART_RELATED_TYPE = new MediaType("multipart", "related");
    public static final String MULTIPART_RELATED_APPLICATION_DICOM = "multipart/related;type=\"application/dicom\"";
    public static final MediaType MULTIPART_RELATED_APPLICATION_DICOM_TYPE = new MediaType("multipart", "related", Collections.singletonMap("type", "application/dicom"));
    public static final String MULTIPART_RELATED_APPLICATION_DICOM_XML = "multipart/related;type=\"application/dicom+xml\"";
    public static final MediaType MULTIPART_RELATED_APPLICATION_DICOM_XML_TYPE = new MediaType("multipart", "related", Collections.singletonMap("type", "application/dicom+xml"));
    public static final String MODEL_STL = "model/stl";
    public static final MediaType MODEL_STL_TYPE = new MediaType("model", "stl");
    public static final String MODEL_X_STL_BINARY = "model/x.stl-binary";
    public static final MediaType MODEL_X_STL_BINARY_TYPE = new MediaType("model", "x.stl-binary");
    public static final String APPLICATION_SLA = "application/sla";
    public static final MediaType APPLICATION_SLA_TYPE = new MediaType("application", "sla");
    public static final String MODEL_OBJ = "model/obj";
    public static final MediaType MODEL_OBJ_TYPE = new MediaType("model", "obj");
    public static final String MODEL_MTL = "model/mtl";
    public static final MediaType MODEL_MTL_TYPE = new MediaType("model", "mtl");
    public static final String APPLICATION_VND_GENOZIP = "application/vnd.genozip";
    public static final MediaType APPLICATION_VND_GENOZIP_TYPE = new MediaType("application", "vnd.genozip");
    public static final String APPLICATION_X_BZIP2 = "application/x-bzip2";
    public static final MediaType APPLICATION_X_BZIP2_TYPE = new MediaType("application", "x-bzip2");
    public static final String APPLICATION_PRS_VCFBZIP = "application/prs.vcfbzip";
    public static final MediaType APPLICATION_PRS_VCFBZIP_TYPE = new MediaType("application", "prs.vcfbzip");
    public static final String APPLICATION_PRS_VCFBZIP2 = "application/prs.vcfbzip2";
    public static final MediaType APPLICATION_PRS_VCFBZIP2_TYPE = new MediaType("application", "prs.vcfbzip2");
    public static final String TOKEN = "([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)";
    public static final String QUOTED = "\"([^\"]*)\"";
    public static final Pattern TYPE_SUBTYPE = Pattern.compile("([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)/([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)");
    public static final Pattern PARAMETER = Pattern.compile(";\\s*(?:([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)=(?:([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)|\"([^\"]*)\"))?");
    public final String type;
    public final String subtype;
    public final String charset;
    public final String mediaType;
    public Map<String, String> parameters;

    public MediaType() {
        this(null, MEDIA_TYPE_WILDCARD, MEDIA_TYPE_WILDCARD, null, null);
    }

    public MediaType(String mediaType) {
        this(mediaType, MEDIA_TYPE_WILDCARD, MEDIA_TYPE_WILDCARD, null, null);
    }

    public MediaType(String type, String subtype) {
        this(null, type, subtype, null, null);
    }

    public MediaType(String type, String subtype, String charset) {
        this(null, type, subtype, charset, null);
    }

    public MediaType(String mediaType, String type, String subtype, String charset) {
        this(mediaType, type, subtype, charset, null);
    }

    public MediaType(String type, String subtype, Map<String, String> params) {
        this(null, type, subtype, null, MediaType.createParametersMap(params));
    }

    public MediaType(String type, String subtype, String charset, Map<String, String> params) {
        this(null, type, subtype, charset, MediaType.createParametersMap(params));
    }

    public MediaType(String mediaType, String type, String subtype, String charset, Map<String, String> params) {
        this.type = null == type ? MEDIA_TYPE_WILDCARD : type;
        this.subtype = null == subtype ? MEDIA_TYPE_WILDCARD : subtype;
        this.charset = null == charset ? "UTF-8" : charset;
        String string = this.mediaType = null == mediaType ? this.type + "/" + this.subtype + ";charset=" + this.charset : mediaType;
        if (MapKit.isNotEmpty(params)) {
            params = new TreeMap<String, String>((o1, o2) -> o1.compareToIgnoreCase((String)o2));
        }
        HashMap<String, String> hashMap = params = null == params ? new HashMap<String, String>() : params;
        if (null != charset && !charset.isEmpty()) {
            params.put(CHARSET_PARAMETER, charset);
        }
        this.parameters = Collections.unmodifiableMap(params);
    }

    public static MediaType valueOf(String text) {
        Matcher typeSubtype = TYPE_SUBTYPE.matcher(text);
        if (!typeSubtype.lookingAt()) {
            throw new IllegalArgumentException("No subtype found for: \"" + text + "\"");
        }
        String type = typeSubtype.group(1).toLowerCase(Locale.US);
        String subtype = typeSubtype.group(2).toLowerCase(Locale.US);
        String charset = null;
        Matcher parameter = PARAMETER.matcher(text);
        int s = typeSubtype.end();
        while (s < text.length()) {
            parameter.region(s, text.length());
            if (!parameter.lookingAt()) {
                throw new IllegalArgumentException("Parameter is not formatted correctly: " + text.substring(s) + " for:" + text);
            }
            String name = parameter.group(1);
            if (null != name && name.equalsIgnoreCase(CHARSET_PARAMETER)) {
                String token = parameter.group(2);
                String charsetParameter = null != token ? (token.startsWith("'") && token.endsWith("'") && token.length() > 2 ? token.substring(1, token.length() - 1) : token) : parameter.group(3);
                if (null != charset && !charsetParameter.equalsIgnoreCase(charset)) {
                    throw new IllegalArgumentException("Multiple charsets defined: " + charset + " and: " + charsetParameter + " for: " + text);
                }
                charset = charsetParameter;
            }
            s = parameter.end();
        }
        return new MediaType(text, type, subtype, charset);
    }

    private static TreeMap<String, String> createParametersMap(Map<String, String> initialValues) {
        TreeMap<String, String> map = new TreeMap<String, String>((o1, o2) -> o1.compareToIgnoreCase((String)o2));
        if (null != initialValues) {
            for (Map.Entry<String, String> e : initialValues.entrySet()) {
                map.put(e.getKey().toLowerCase(), e.getValue());
            }
        }
        return map;
    }

    public static boolean isSTLType(MediaType mediaType) {
        return MediaType.equalsIgnoreParameters(mediaType, MODEL_STL_TYPE) || MediaType.equalsIgnoreParameters(mediaType, MODEL_X_STL_BINARY_TYPE) || MediaType.equalsIgnoreParameters(mediaType, APPLICATION_SLA_TYPE);
    }

    public static boolean isSTLType(String type) {
        return MODEL_STL.equalsIgnoreCase(type) || MODEL_X_STL_BINARY.equalsIgnoreCase(type) || APPLICATION_SLA.equalsIgnoreCase(type);
    }

    public static boolean equalsIgnoreParameters(MediaType type1, MediaType type2) {
        return type1.getType().equalsIgnoreCase(type2.getType()) && type1.getSubtype().equalsIgnoreCase(type2.getSubtype());
    }

    public static MediaType getMultiPartRelatedType(MediaType mediaType) {
        if (!MULTIPART_RELATED_TYPE.isCompatible(mediaType)) {
            return null;
        }
        String type = mediaType.getParameters().get("type");
        if (type == null) {
            return WILDCARD_TYPE;
        }
        MediaType partType = MediaType.valueOf(type);
        if (mediaType.getParameters().size() > 1) {
            HashMap<String, String> params = new HashMap<String, String>(mediaType.getParameters());
            params.remove("type");
            partType = new MediaType(partType.getType(), partType.getSubtype(), params);
        }
        return partType;
    }

    public boolean equals(Object object) {
        if (!(object instanceof MediaType)) {
            return false;
        }
        MediaType other = (MediaType)object;
        return this.type.equalsIgnoreCase(other.type) && this.subtype.equalsIgnoreCase(other.subtype) && this.parameters.equals(other.parameters);
    }

    public int hashCode() {
        return (this.type.toLowerCase() + this.subtype.toLowerCase()).hashCode() + this.parameters.hashCode();
    }

    public String toString() {
        return this.mediaType;
    }

    public String type() {
        return this.type;
    }

    public String subtype() {
        return this.subtype;
    }

    public Charset charset() {
        return this.charset(null);
    }

    public Charset charset(Charset defaultValue) {
        try {
            return null != this.charset ? Charset.forName(this.charset) : defaultValue;
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }

    public boolean isCompatible(MediaType mediaType) {
        return null != mediaType && (this.type.equals(MEDIA_TYPE_WILDCARD) || mediaType.type.equals(MEDIA_TYPE_WILDCARD) || this.type.equalsIgnoreCase(mediaType.type) && (this.subtype.equals(MEDIA_TYPE_WILDCARD) || mediaType.subtype.equals(MEDIA_TYPE_WILDCARD)) || this.type.equalsIgnoreCase(mediaType.type) && this.subtype.equalsIgnoreCase(mediaType.subtype));
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getSubtype() {
        return this.subtype;
    }

    @Generated
    public String getCharset() {
        return this.charset;
    }

    @Generated
    public String getMediaType() {
        return this.mediaType;
    }

    @Generated
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    @Generated
    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }
}

