/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.lang.annotation.resolve;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.miaixz.bus.core.center.map.reference.WeakConcurrentMap;
import org.miaixz.bus.core.lang.annotation.resolve.GenericAnnotationMapping;
import org.miaixz.bus.core.lang.annotation.resolve.RepeatableAnnotationCollector;
import org.miaixz.bus.core.lang.annotation.resolve.ResolvedAnnotationMapping;
import org.miaixz.bus.core.lang.annotation.resolve.elements.HierarchicalAnnotatedElements;
import org.miaixz.bus.core.lang.annotation.resolve.elements.MetaAnnotatedElement;
import org.miaixz.bus.core.lang.annotation.resolve.elements.RepeatableMetaAnnotatedElement;
import org.miaixz.bus.core.xyz.AnnoKit;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.ObjectKit;

public class AnnotatedElements {
    private static final Map<AnnotatedElement, MetaAnnotatedElement<ResolvedAnnotationMapping>> RESOLVED_ELEMENT_CACHE = new WeakConcurrentMap<AnnotatedElement, MetaAnnotatedElement<ResolvedAnnotationMapping>>();
    private static final Map<AnnotatedElement, MetaAnnotatedElement<GenericAnnotationMapping>> ELEMENT_CACHE = new WeakConcurrentMap<AnnotatedElement, MetaAnnotatedElement<GenericAnnotationMapping>>();
    private static final Map<AnnotatedElement, RepeatableMetaAnnotatedElement<ResolvedAnnotationMapping>> RESOLVED_REPEATABLE_ELEMENT_CACHE = new WeakConcurrentMap<AnnotatedElement, RepeatableMetaAnnotatedElement<ResolvedAnnotationMapping>>();
    private static final Map<AnnotatedElement, RepeatableMetaAnnotatedElement<GenericAnnotationMapping>> REPEATABLE_ELEMENT_CACHE = new WeakConcurrentMap<AnnotatedElement, RepeatableMetaAnnotatedElement<GenericAnnotationMapping>>();

    public static boolean isAnnotated(AnnotatedElement element, Class<? extends Annotation> annotationType) {
        return AnnotatedElements.toHierarchyMetaElement(element, false).isAnnotationPresent(annotationType);
    }

    public static <T extends Annotation> T findAnnotation(AnnotatedElement element, Class<T> annotationType) {
        return AnnotatedElements.toHierarchyMetaElement(element, false).getAnnotation(annotationType);
    }

    public static <T extends Annotation> T[] findAllAnnotations(AnnotatedElement element, Class<T> annotationType) {
        return AnnotatedElements.toHierarchyRepeatableMetaElement(element, false).getAnnotationsByType(annotationType);
    }

    public static Annotation[] findAnnotations(AnnotatedElement element) {
        return AnnotatedElements.toHierarchyMetaElement(element, false).getAnnotations();
    }

    public static <T extends Annotation> T findResolvedAnnotation(AnnotatedElement element, Class<T> annotationType) {
        return AnnotatedElements.toHierarchyMetaElement(element, true).getAnnotation(annotationType);
    }

    public static Annotation[] findResolvedAnnotations(AnnotatedElement element) {
        return AnnotatedElements.toHierarchyMetaElement(element, true).getAnnotations();
    }

    public static <T extends Annotation> T[] findAllResolvedAnnotations(AnnotatedElement element, Class<T> annotationType) {
        return AnnotatedElements.toHierarchyRepeatableMetaElement(element, true).getAnnotationsByType(annotationType);
    }

    public static <T extends Annotation> T findDirectlyAnnotation(AnnotatedElement element, Class<T> annotationType) {
        return AnnotatedElements.toHierarchyMetaElement(element, false).getDeclaredAnnotation(annotationType);
    }

    public static <T extends Annotation> T[] findAllDirectlyAnnotations(AnnotatedElement element, Class<T> annotationType) {
        return AnnotatedElements.toHierarchyRepeatableMetaElement(element, false).getDeclaredAnnotationsByType(annotationType);
    }

    public static Annotation[] findDirectlyAnnotations(AnnotatedElement element) {
        return AnnotatedElements.toHierarchyMetaElement(element, false).getDeclaredAnnotations();
    }

    public static <T extends Annotation> T findDirectlyResolvedAnnotation(AnnotatedElement element, Class<T> annotationType) {
        return AnnotatedElements.toHierarchyMetaElement(element, true).getDeclaredAnnotation(annotationType);
    }

    public static Annotation[] findDirectlyResolvedAnnotations(AnnotatedElement element) {
        return AnnotatedElements.toHierarchyMetaElement(element, true).getDeclaredAnnotations();
    }

    public static <T extends Annotation> T[] findAllDirectlyResolvedAnnotations(AnnotatedElement element, Class<T> annotationType) {
        return AnnotatedElements.toHierarchyRepeatableMetaElement(element, true).getDeclaredAnnotationsByType(annotationType);
    }

    public static boolean isAnnotationPresent(AnnotatedElement element, Class<? extends Annotation> annotationType) {
        return AnnotatedElements.toMetaElement(element, false).isAnnotationPresent(annotationType);
    }

    public static <T extends Annotation> T getAnnotation(AnnotatedElement element, Class<T> annotationType) {
        return AnnotatedElements.toMetaElement(element, false).getAnnotation(annotationType);
    }

    public static Annotation[] getAnnotations(AnnotatedElement element) {
        return AnnotatedElements.toMetaElement(element, false).getAnnotations();
    }

    public static <T extends Annotation> T[] getAllAnnotations(AnnotatedElement element, Class<T> annotationType) {
        return AnnotatedElements.toRepeatableMetaElement(element, false).getAnnotationsByType(annotationType);
    }

    public static <T extends Annotation> T getResolvedAnnotation(AnnotatedElement element, Class<T> annotationType) {
        return AnnotatedElements.toMetaElement(element, true).getAnnotation(annotationType);
    }

    public static Annotation[] getResolvedAnnotations(AnnotatedElement element) {
        return AnnotatedElements.toMetaElement(element, true).getAnnotations();
    }

    public static <T extends Annotation> T[] getAllResolvedAnnotations(AnnotatedElement element, Class<T> annotationType) {
        return AnnotatedElements.toRepeatableMetaElement(element, true).getAnnotationsByType(annotationType);
    }

    public static <T extends Annotation> T getDirectlyAnnotation(AnnotatedElement element, Class<T> annotationType) {
        return AnnotatedElements.toMetaElement(element, false).getDeclaredAnnotation(annotationType);
    }

    public static <T extends Annotation> T[] getAllDirectlyAnnotations(AnnotatedElement element, Class<T> annotationType) {
        return AnnotatedElements.toRepeatableMetaElement(element, false).getDeclaredAnnotationsByType(annotationType);
    }

    public static Annotation[] getDirectlyAnnotations(AnnotatedElement element) {
        return AnnotatedElements.toMetaElement(element, false).getDeclaredAnnotations();
    }

    public static <T extends Annotation> T getDirectlyResolvedAnnotation(AnnotatedElement element, Class<T> annotationType) {
        return AnnotatedElements.toMetaElement(element, true).getDeclaredAnnotation(annotationType);
    }

    public static Annotation[] getDirectlyResolvedAnnotations(AnnotatedElement element) {
        return AnnotatedElements.toMetaElement(element, true).getDeclaredAnnotations();
    }

    public static <T extends Annotation> T[] getAllDirectlyResolvedAnnotations(AnnotatedElement element, Class<T> annotationType) {
        return AnnotatedElements.toRepeatableMetaElement(element, true).getDeclaredAnnotationsByType(annotationType);
    }

    public static AnnotatedElement toHierarchyMetaElement(AnnotatedElement element, boolean resolved) {
        if (Objects.isNull(element)) {
            return AnnotatedElements.emptyElement();
        }
        if (resolved) {
            return HierarchicalAnnotatedElements.of(element, (es, e) -> AnnotatedElements.getResolvedMetaElementCache(e));
        }
        return HierarchicalAnnotatedElements.of(element, (es, e) -> AnnotatedElements.getMetaElementCache(e));
    }

    public static AnnotatedElement toHierarchyRepeatableMetaElement(AnnotatedElement element, boolean resolved) {
        if (Objects.isNull(element)) {
            return AnnotatedElements.emptyElement();
        }
        if (resolved) {
            return HierarchicalAnnotatedElements.of(element, (es, e) -> AnnotatedElements.getResolvedRepeatableMetaElementCache(e));
        }
        return HierarchicalAnnotatedElements.of(element, (es, e) -> AnnotatedElements.getRepeatableMetaElementCache(e));
    }

    public static AnnotatedElement toHierarchyElement(AnnotatedElement element) {
        return ObjectKit.defaultIfNull(element, ele -> HierarchicalAnnotatedElements.of(ele, (es, e) -> e), AnnotatedElements.emptyElement());
    }

    public static AnnotatedElement toMetaElement(AnnotatedElement element, boolean resolved) {
        return ObjectKit.defaultIfNull(element, e -> resolved ? AnnotatedElements.getResolvedMetaElementCache(e) : AnnotatedElements.getMetaElementCache(e), AnnotatedElements.emptyElement());
    }

    public static AnnotatedElement toRepeatableMetaElement(AnnotatedElement element, boolean resolved) {
        return ObjectKit.defaultIfNull(element, e -> resolved ? AnnotatedElements.getResolvedRepeatableMetaElementCache(e) : AnnotatedElements.getRepeatableMetaElementCache(e), AnnotatedElements.emptyElement());
    }

    public static AnnotatedElement toRepeatableMetaElement(AnnotatedElement element, RepeatableAnnotationCollector collector, boolean resolved) {
        if (Objects.isNull(element)) {
            return AnnotatedElements.emptyElement();
        }
        collector = ObjectKit.defaultIfNull(collector, RepeatableAnnotationCollector.none());
        if (resolved) {
            return RepeatableMetaAnnotatedElement.create(collector, element, (source, annotation) -> ResolvedAnnotationMapping.create((ResolvedAnnotationMapping)source, annotation, true));
        }
        return RepeatableMetaAnnotatedElement.create(collector, element, (source, annotation) -> GenericAnnotationMapping.create(annotation, Objects.isNull(source)));
    }

    public static AnnotatedElement asElement(Annotation ... annotations) {
        return ArrayKit.isEmpty(annotations = ArrayKit.filter(annotations, Objects::nonNull)) ? AnnotatedElements.emptyElement() : new ConstantElement(annotations);
    }

    public static AnnotatedElement emptyElement() {
        return EmptyElement.INSTANCE;
    }

    public static MetaAnnotatedElement<ResolvedAnnotationMapping> getResolvedMetaElementCache(AnnotatedElement element) {
        return RESOLVED_ELEMENT_CACHE.computeIfAbsent(element, ele -> MetaAnnotatedElement.create(element, (source, annotation) -> ResolvedAnnotationMapping.create(source, annotation, true)));
    }

    public static MetaAnnotatedElement<GenericAnnotationMapping> getMetaElementCache(AnnotatedElement element) {
        return ELEMENT_CACHE.computeIfAbsent(element, ele -> MetaAnnotatedElement.create(element, (source, annotation) -> GenericAnnotationMapping.create(annotation, Objects.isNull(source))));
    }

    public static RepeatableMetaAnnotatedElement<ResolvedAnnotationMapping> getResolvedRepeatableMetaElementCache(AnnotatedElement element) {
        return RESOLVED_REPEATABLE_ELEMENT_CACHE.computeIfAbsent(element, ele -> RepeatableMetaAnnotatedElement.create(element, (source, annotation) -> ResolvedAnnotationMapping.create(source, annotation, true)));
    }

    public static RepeatableMetaAnnotatedElement<GenericAnnotationMapping> getRepeatableMetaElementCache(AnnotatedElement element) {
        return REPEATABLE_ELEMENT_CACHE.computeIfAbsent(element, ele -> RepeatableMetaAnnotatedElement.create(element, (source, annotation) -> GenericAnnotationMapping.create(annotation, Objects.isNull(source))));
    }

    public static void clearCaches() {
        ELEMENT_CACHE.clear();
        RESOLVED_ELEMENT_CACHE.clear();
        REPEATABLE_ELEMENT_CACHE.clear();
        RESOLVED_REPEATABLE_ELEMENT_CACHE.clear();
        RepeatableAnnotationCollector.clearSingletonCaches();
        AnnoKit.clearCaches();
    }

    private static class ConstantElement
    implements AnnotatedElement {
        private final Annotation[] annotations;

        ConstantElement(Annotation[] annotations) {
            this.annotations = Objects.requireNonNull(annotations);
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            return (T)((Annotation)Stream.of(this.annotations).filter(annotation -> Objects.equals(annotation.annotationType(), annotationClass)).findFirst().map(annotationClass::cast).orElse(null));
        }

        @Override
        public Annotation[] getAnnotations() {
            return (Annotation[])this.annotations.clone();
        }

        @Override
        public Annotation[] getDeclaredAnnotations() {
            return (Annotation[])this.annotations.clone();
        }
    }

    private static class EmptyElement
    implements AnnotatedElement {
        static final EmptyElement INSTANCE = new EmptyElement();

        private EmptyElement() {
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            return null;
        }

        @Override
        public Annotation[] getAnnotations() {
            return new Annotation[0];
        }

        @Override
        public Annotation[] getDeclaredAnnotations() {
            return new Annotation[0];
        }
    }
}

