/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.lang.annotation.resolve;

import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.miaixz.bus.core.center.array.ArrayValidator;
import org.miaixz.bus.core.center.map.reference.WeakConcurrentMap;
import org.miaixz.bus.core.text.CharsBacker;
import org.miaixz.bus.core.xyz.AnnoKit;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.CollKit;
import org.miaixz.bus.core.xyz.MethodKit;

public interface RepeatableAnnotationCollector {
    public static RepeatableAnnotationCollector none() {
        return None.INSTANCE;
    }

    public static RepeatableAnnotationCollector standard() {
        return Standard.INSTANCE;
    }

    public static RepeatableAnnotationCollector condition(BiPredicate<Annotation, Method> predicate) {
        return new Condition(predicate);
    }

    public static RepeatableAnnotationCollector full() {
        return Full.INSTANCE;
    }

    public static void clearSingletonCaches() {
        Standard.INSTANCE.repeatableMethodCache.clear();
        Full.INSTANCE.repeatableMethodCache.clear();
    }

    public List<Annotation> getFinalRepeatableAnnotations(Annotation var1);

    public List<Annotation> getAllRepeatableAnnotations(Annotation var1);

    public <T extends Annotation> List<T> getRepeatableAnnotations(Annotation var1, Class<T> var2);

    public static class None
    implements RepeatableAnnotationCollector {
        private static final None INSTANCE = new None();

        @Override
        public List<Annotation> getFinalRepeatableAnnotations(Annotation annotation) {
            return Objects.isNull(annotation) ? Collections.emptyList() : Collections.singletonList(annotation);
        }

        @Override
        public List<Annotation> getAllRepeatableAnnotations(Annotation annotation) {
            return Objects.isNull(annotation) ? Collections.emptyList() : Collections.singletonList(annotation);
        }

        @Override
        public <T extends Annotation> List<T> getRepeatableAnnotations(Annotation annotation, Class<T> annotationType) {
            if (Objects.isNull(annotation)) {
                return Collections.emptyList();
            }
            return Objects.equals(annotation.annotationType(), annotationType) ? Collections.singletonList((Annotation)annotationType.cast(annotation)) : Collections.emptyList();
        }
    }

    public static class Standard
    extends AbstractCollector {
        private static final String VALUE = "value";
        private static final Standard INSTANCE = new Standard();
        private static final Object NONE = new Object();
        private final Map<Class<? extends Annotation>, Object> repeatableMethodCache = new WeakConcurrentMap<Class<? extends Annotation>, Object>();

        Standard() {
        }

        @Override
        protected List<Method> resolveRepeatableMethod(Annotation annotation) {
            Object cache = this.repeatableMethodCache.computeIfAbsent(annotation.annotationType(), this::resolveRepeatableMethodFromType);
            return cache == NONE ? null : Collections.singletonList((Method)cache);
        }

        private Object resolveRepeatableMethodFromType(Class<? extends Annotation> annotationType) {
            Method[] attributes = AnnoKit.getAnnotationAttributes(annotationType);
            if (attributes.length != 1) {
                return NONE;
            }
            return this.isRepeatableMethod(attributes[0]) ? attributes[0] : NONE;
        }

        protected boolean isRepeatableMethod(Method attribute) {
            if (!CharsBacker.equals(VALUE, attribute.getName())) {
                return false;
            }
            Class<?> attributeType = attribute.getReturnType();
            return attributeType.isArray() && attributeType.getComponentType().isAnnotation() && attributeType.getComponentType().isAnnotationPresent(Repeatable.class);
        }
    }

    public static class Condition
    extends AbstractCollector {
        private final BiPredicate<Annotation, Method> predicate;

        Condition(BiPredicate<Annotation, Method> predicate) {
            this.predicate = Objects.requireNonNull(predicate);
        }

        @Override
        protected List<Method> resolveRepeatableMethod(Annotation annotation) {
            return Stream.of(AnnoKit.getAnnotationAttributes(annotation.annotationType())).filter(method -> this.predicate.test(annotation, (Method)method)).collect(Collectors.toList());
        }
    }

    public static class Full
    extends AbstractCollector {
        private static final Full INSTANCE = new Full();
        private static final Object NONE = new Object();
        private final Map<Class<? extends Annotation>, Object> repeatableMethodCache = new WeakConcurrentMap<Class<? extends Annotation>, Object>();

        Full() {
        }

        @Override
        protected List<Method> resolveRepeatableMethod(Annotation annotation) {
            Object cache = this.repeatableMethodCache.computeIfAbsent(annotation.annotationType(), this::resolveRepeatableMethodFromType);
            return cache == NONE ? null : (List)cache;
        }

        private Object resolveRepeatableMethodFromType(Class<? extends Annotation> annotationType) {
            List methods = Stream.of(AnnoKit.getAnnotationAttributes(annotationType)).filter(this::isRepeatableMethod).collect(Collectors.toList());
            return methods.isEmpty() ? NONE : methods;
        }

        protected boolean isRepeatableMethod(Method attribute) {
            Class<?> attributeType = attribute.getReturnType();
            return attributeType.isArray() && attributeType.getComponentType().isAnnotation() && attributeType.getComponentType().isAnnotationPresent(Repeatable.class);
        }
    }

    public static abstract class AbstractCollector
    implements RepeatableAnnotationCollector {
        @Override
        public final List<Annotation> getFinalRepeatableAnnotations(Annotation annotation) {
            return this.find(annotation, null, false);
        }

        @Override
        public List<Annotation> getAllRepeatableAnnotations(Annotation annotation) {
            return this.find(annotation, null, true);
        }

        @Override
        public <T extends Annotation> List<T> getRepeatableAnnotations(Annotation annotation, Class<T> annotationType) {
            List<Annotation> annotations = this.find(annotation, t -> Objects.equals(t.annotationType(), annotationType), false);
            return annotations.stream().map(annotationType::cast).collect(Collectors.toList());
        }

        private List<Annotation> find(Annotation annotation, Predicate<Annotation> condition, boolean accumulate) {
            if (Objects.isNull(annotation)) {
                return Collections.emptyList();
            }
            boolean hasCondition = Objects.nonNull(condition);
            ArrayList<Annotation> results = new ArrayList<Annotation>();
            LinkedList<Annotation> deque = new LinkedList<Annotation>();
            deque.add(annotation);
            while (!deque.isEmpty()) {
                boolean isTarget;
                Annotation source = (Annotation)deque.removeFirst();
                List<Method> repeatableMethods = this.resolveRepeatableMethod(source);
                if (accumulate) {
                    results.add(source);
                }
                boolean bl = isTarget = hasCondition && condition.test(source);
                if (CollKit.isEmpty(repeatableMethods) || isTarget) {
                    boolean shouldProcess = !accumulate && (!hasCondition || isTarget);
                    if (!shouldProcess) continue;
                    results.add(source);
                    continue;
                }
                Annotation[] repeatableAnnotation = (Annotation[])repeatableMethods.stream().map(method -> this.getRepeatableAnnotationsFormAttribute(source, (Method)method)).filter(ArrayValidator::isNotEmpty).flatMap(Stream::of).toArray(Annotation[]::new);
                if (!ArrayKit.isNotEmpty(repeatableAnnotation)) continue;
                CollKit.addAll(deque, repeatableAnnotation);
            }
            return results;
        }

        protected Annotation[] getRepeatableAnnotationsFormAttribute(Annotation annotation, Method method) {
            return (Annotation[])MethodKit.invoke((Object)annotation, method, new Object[0]);
        }

        protected abstract List<Method> resolveRepeatableMethod(Annotation var1);
    }
}

