/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.lang.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.miaixz.bus.core.Loader;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.event.Event;
import org.miaixz.bus.core.lang.event.EventPublisher;
import org.miaixz.bus.core.lang.event.Subscriber;
import org.miaixz.bus.core.lang.loader.LazyFunLoader;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.core.xyz.ThreadKit;

public class SimpleEventPublisher
implements EventPublisher {
    private final List<Subscriber> subscribers;
    private Loader<ExecutorService> executorServiceLoader;

    public SimpleEventPublisher(List<Subscriber> subscribers, Loader<ExecutorService> executorServiceLoader) {
        this.subscribers = ObjectKit.defaultIfNull(subscribers, ArrayList::new);
        this.executorServiceLoader = ObjectKit.defaultIfNull(executorServiceLoader, LazyFunLoader.of(ThreadKit::newExecutor));
    }

    public static SimpleEventPublisher of() {
        return SimpleEventPublisher.of(null);
    }

    public static SimpleEventPublisher of(List<Subscriber> subscribers) {
        return new SimpleEventPublisher(subscribers, null);
    }

    public SimpleEventPublisher setExecutorService(ExecutorService executorService) {
        this.executorServiceLoader = () -> Assert.notNull(executorService);
        return this;
    }

    @Override
    public EventPublisher register(Subscriber subscriber) {
        this.subscribers.add(subscriber);
        Collections.sort(this.subscribers);
        return this;
    }

    @Override
    public void publish(Event event) {
        for (Subscriber subscriber : this.subscribers) {
            if (subscriber.async()) {
                this.executorServiceLoader.get().submit(() -> subscriber.update(event));
                continue;
            }
            subscriber.update(event);
        }
    }
}

