/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.lang.loader;

import java.io.IOException;
import java.util.Enumeration;
import org.miaixz.bus.core.io.resource.Resource;
import org.miaixz.bus.core.lang.loader.AntFilter;
import org.miaixz.bus.core.lang.loader.Filter;
import org.miaixz.bus.core.lang.loader.Loader;
import org.miaixz.bus.core.lang.loader.PatternLoader;
import org.miaixz.bus.core.lang.loader.StdLoader;

public class AntLoader
extends PatternLoader
implements Loader {
    public AntLoader() {
        this(new StdLoader());
    }

    public AntLoader(ClassLoader classLoader) {
        this(new StdLoader(classLoader));
    }

    public AntLoader(Loader delegate) {
        super(delegate);
    }

    @Override
    public Enumeration<Resource> load(String pattern, boolean recursively, Filter filter) throws IOException {
        if (Math.max(pattern.indexOf(42), pattern.indexOf(63)) < 0) {
            return this.delegate.load(pattern, recursively, filter);
        }
        return super.load(pattern, recursively, filter);
    }

    @Override
    protected String path(String ant) {
        int index = 0x7FFFFFFE;
        if (ant.contains("*") && ant.indexOf(42) < index) {
            index = ant.indexOf(42);
        }
        if (ant.contains("?") && ant.indexOf(63) < index) {
            index = ant.indexOf(63);
        }
        return ant.substring(0, ant.lastIndexOf(47, index) + 1);
    }

    @Override
    protected boolean recursively(String ant) {
        return true;
    }

    @Override
    protected Filter filter(String ant) {
        return new AntFilter(ant);
    }
}

