/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.lang.mutable;

import org.miaixz.bus.core.lang.mutable.Mutable;
import org.miaixz.bus.core.xyz.CompareKit;

public class MutableInt
extends Number
implements Comparable<MutableInt>,
Mutable<Number> {
    private static final long serialVersionUID = 2852270595187L;
    private int value;

    public MutableInt() {
    }

    public MutableInt(int value) {
        this.value = value;
    }

    public MutableInt(Number value) {
        this(value.intValue());
    }

    public MutableInt(String value) throws NumberFormatException {
        this.value = Integer.parseInt(value);
    }

    @Override
    public Integer get() {
        return this.value;
    }

    @Override
    public void set(int value) {
        this.value = value;
    }

    @Override
    public void set(Number value) {
        this.value = value.intValue();
    }

    public MutableInt increment() {
        ++this.value;
        return this;
    }

    public MutableInt decrement() {
        --this.value;
        return this;
    }

    public int incrementAndGet() {
        return ++this.value;
    }

    public int getAndIncrement() {
        return this.value++;
    }

    public int decrementAndGet() {
        return --this.value;
    }

    public int getAndDecrement() {
        return this.value--;
    }

    public MutableInt add(int operand) {
        this.value += operand;
        return this;
    }

    public MutableInt add(Number operand) {
        this.value += operand.intValue();
        return this;
    }

    public MutableInt subtract(int operand) {
        this.value -= operand;
        return this;
    }

    public MutableInt subtract(Number operand) {
        this.value -= operand.intValue();
        return this;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (object instanceof MutableInt) {
            return this.value == ((MutableInt)object).intValue();
        }
        return false;
    }

    public int hashCode() {
        return this.value;
    }

    @Override
    public int compareTo(MutableInt other) {
        return CompareKit.compare(this.value, other.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

