/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.lang.mutable;

import org.miaixz.bus.core.lang.mutable.Mutable;
import org.miaixz.bus.core.xyz.CompareKit;

public class MutableLong
extends Number
implements Comparable<MutableLong>,
Mutable<Number> {
    private static final long serialVersionUID = 2852270769985L;
    private long value;

    public MutableLong() {
    }

    public MutableLong(long value) {
        this.value = value;
    }

    public MutableLong(Number value) {
        this(value.longValue());
    }

    public MutableLong(String value) throws NumberFormatException {
        this.value = Long.parseLong(value);
    }

    @Override
    public Long get() {
        return this.value;
    }

    @Override
    public void set(long value) {
        this.value = value;
    }

    @Override
    public void set(Number value) {
        this.value = value.longValue();
    }

    public MutableLong increment() {
        ++this.value;
        return this;
    }

    public MutableLong decrement() {
        --this.value;
        return this;
    }

    public MutableLong add(long operand) {
        this.value += operand;
        return this;
    }

    public MutableLong add(Number operand) {
        this.value += operand.longValue();
        return this;
    }

    public MutableLong subtract(long operand) {
        this.value -= operand;
        return this;
    }

    public MutableLong subtract(Number operand) {
        this.value -= operand.longValue();
        return this;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (object instanceof MutableLong) {
            return this.value == ((MutableLong)object).longValue();
        }
        return false;
    }

    public int hashCode() {
        return Long.hashCode(this.value);
    }

    @Override
    public int compareTo(MutableLong other) {
        return CompareKit.compare(this.value, other.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

