/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.lang.range;

import java.util.Objects;
import org.miaixz.bus.core.center.function.PredicateX;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.range.Bound;
import org.miaixz.bus.core.lang.range.BoundedRangeOperation;
import org.miaixz.bus.core.lang.range.NoneLowerBound;
import org.miaixz.bus.core.lang.range.NoneUpperBound;

public class BoundedRange<T extends Comparable<? super T>>
implements PredicateX<T> {
    private static final long serialVersionUID = 2852273351363L;
    private static final BoundedRange ALL = new BoundedRange(Bound.noneLowerBound(), Bound.noneUpperBound());
    private final Bound<T> lowerBound;
    private final Bound<T> upperBound;

    BoundedRange(Bound<T> lowerBound, Bound<T> upperBound) {
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    public static <T extends Comparable<? super T>> BoundedRange<T> all() {
        return ALL;
    }

    public static <T extends Comparable<? super T>> BoundedRange<T> close(T lowerBound, T upperBound) {
        Objects.requireNonNull(lowerBound);
        Objects.requireNonNull(upperBound);
        return BoundedRange.checkEmpty(new BoundedRange<T>(Bound.atLeast(lowerBound), Bound.atMost(upperBound)));
    }

    public static <T extends Comparable<? super T>> BoundedRange<T> open(T lowerBound, T upperBound) {
        Objects.requireNonNull(lowerBound);
        Objects.requireNonNull(upperBound);
        return BoundedRange.checkEmpty(new BoundedRange<T>(Bound.greaterThan(lowerBound), Bound.lessThan(upperBound)));
    }

    public static <T extends Comparable<? super T>> BoundedRange<T> closeOpen(T lowerBound, T upperBound) {
        Objects.requireNonNull(lowerBound);
        Objects.requireNonNull(upperBound);
        return BoundedRange.checkEmpty(new BoundedRange<T>(Bound.atLeast(lowerBound), Bound.lessThan(upperBound)));
    }

    public static <T extends Comparable<? super T>> BoundedRange<T> openClose(T lowerBound, T upperBound) {
        Objects.requireNonNull(lowerBound);
        Objects.requireNonNull(upperBound);
        return BoundedRange.checkEmpty(new BoundedRange<T>(Bound.greaterThan(lowerBound), Bound.atMost(upperBound)));
    }

    public static <T extends Comparable<? super T>> BoundedRange<T> greaterThan(T lowerBound) {
        return Bound.greaterThan(lowerBound).toRange();
    }

    public static <T extends Comparable<? super T>> BoundedRange<T> atLeast(T lowerBound) {
        return Bound.atLeast(lowerBound).toRange();
    }

    public static <T extends Comparable<? super T>> BoundedRange<T> lessThan(T upperBound) {
        return Bound.lessThan(upperBound).toRange();
    }

    public static <T extends Comparable<? super T>> BoundedRange<T> atMost(T upperBound) {
        return Bound.atMost(upperBound).toRange();
    }

    private static <T extends Comparable<? super T>> BoundedRange<T> checkEmpty(BoundedRange<T> range) {
        Assert.isFalse(range.isEmpty(), "{} is a empty range", range);
        return range;
    }

    public Bound<T> getLowerBound() {
        return this.lowerBound;
    }

    public T getLowerBoundValue() {
        return this.getLowerBound().getValue();
    }

    public boolean hasLowerBound() {
        return Objects.nonNull(this.getLowerBound().getValue());
    }

    public Bound<T> getUpperBound() {
        return this.upperBound;
    }

    public T getUpperBoundValue() {
        return this.getUpperBound().getValue();
    }

    public boolean hasUpperBound() {
        return Objects.nonNull(this.getUpperBound().getValue());
    }

    public boolean isEmpty() {
        Bound<T> low = this.getLowerBound();
        Bound<T> up = this.getUpperBound();
        if (low instanceof NoneLowerBound || up instanceof NoneUpperBound) {
            return false;
        }
        int compareValue = low.getValue().compareTo(up.getValue());
        if (compareValue < 0) {
            return false;
        }
        return compareValue > 0 || !low.getType().isClose() || !up.getType().isClose();
    }

    public String toString() {
        return this.getLowerBound().descBound() + ", " + this.getUpperBound().descBound();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoundedRange that = (BoundedRange)o;
        return this.lowerBound.equals(that.lowerBound) && this.upperBound.equals(that.upperBound);
    }

    public int hashCode() {
        return Objects.hash(this.lowerBound, this.upperBound);
    }

    public boolean isSuperset(BoundedRange<T> other) {
        return this.getLowerBound().compareTo(other.getLowerBound()) <= 0 && this.getUpperBound().compareTo(other.getUpperBound()) >= 0;
    }

    public boolean isProperSuperset(BoundedRange<T> other) {
        return this.getLowerBound().compareTo(other.getLowerBound()) < 0 && this.getUpperBound().compareTo(other.getUpperBound()) > 0;
    }

    public boolean isSubset(BoundedRange<T> other) {
        return this.getLowerBound().compareTo(other.getLowerBound()) >= 0 && this.getUpperBound().compareTo(other.getUpperBound()) <= 0;
    }

    public boolean isProperSubset(BoundedRange<T> other) {
        return this.getLowerBound().compareTo(other.getLowerBound()) > 0 && this.getUpperBound().compareTo(other.getUpperBound()) < 0;
    }

    public boolean isDisjoint(BoundedRange<T> other) {
        return BoundedRangeOperation.isDisjoint(this, other);
    }

    public boolean isIntersected(BoundedRange<T> other) {
        return BoundedRangeOperation.isIntersected(this, other);
    }

    @Override
    public boolean testing(T value) {
        return this.getLowerBound().and(this.getUpperBound()).test(value);
    }

    public BoundedRange<T> unionIfIntersected(BoundedRange<T> other) {
        return BoundedRangeOperation.unionIfIntersected(this, other);
    }

    public BoundedRange<T> span(BoundedRange<T> other) {
        return BoundedRangeOperation.span(this, other);
    }

    public BoundedRange<T> gap(BoundedRange<T> other) {
        return BoundedRangeOperation.gap(this, other);
    }

    public BoundedRange<T> intersection(BoundedRange<T> other) {
        return BoundedRangeOperation.intersection(this, other);
    }

    public BoundedRange<T> subGreatThan(T min) {
        return BoundedRangeOperation.subGreatThan(this, min);
    }

    public BoundedRange<T> subAtLeast(T min) {
        return BoundedRangeOperation.subAtLeast(this, min);
    }

    public BoundedRange<T> subLessThan(T max) {
        return BoundedRangeOperation.subLessThan(this, max);
    }

    public BoundedRange<T> subAtMost(T max) {
        return BoundedRangeOperation.subAtMost(this, max);
    }
}

