/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.lang.range;

import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.miaixz.bus.core.lang.Assert;

public class Range<T>
implements Iterable<T>,
Serializable {
    private static final long serialVersionUID = 2852275092763L;
    private final T start;
    private final T end;
    private final Stepper<T> stepper;
    private final boolean includeStart;
    private final boolean includeEnd;

    public Range(T start, Stepper<T> stepper) {
        this(start, null, (Stepper<Object>)stepper);
    }

    public Range(T start, T end, Stepper<T> stepper) {
        this(start, end, stepper, true, true);
    }

    public Range(T start, T end, Stepper<T> stepper, boolean isIncludeStart, boolean isIncludeEnd) {
        Assert.notNull(start, "First element must be not null!", new Object[0]);
        this.start = start;
        this.end = end;
        this.stepper = stepper;
        this.includeStart = isIncludeStart;
        this.includeEnd = isIncludeEnd;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private int index = 0;
            private T next;
            {
                this.next = this.safeStep(Range.this.start);
            }

            @Override
            public boolean hasNext() {
                if (0 == this.index && Range.this.includeStart) {
                    return true;
                }
                if (null == this.next) {
                    return false;
                }
                return Range.this.includeEnd || !this.next.equals(Range.this.end);
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("Has no next range!");
                }
                return this.nextUncheck();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Can not remove ranged element!");
            }

            private T nextUncheck() {
                Object current;
                if (0 == this.index) {
                    current = Range.this.start;
                    if (!Range.this.includeStart) {
                        ++this.index;
                        return this.nextUncheck();
                    }
                } else {
                    current = this.next;
                    this.next = this.safeStep(this.next);
                }
                ++this.index;
                return current;
            }

            private T safeStep(T base) {
                int index = this.index;
                Object next = null;
                try {
                    next = Range.this.stepper.step(base, Range.this.end, index);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return next;
            }
        };
    }

    public String toString() {
        return "Range [start=" + String.valueOf(this.start) + ", end=" + String.valueOf(this.end) + "]";
    }

    public static interface Stepper<T> {
        public T step(T var1, T var2, int var3);
    }
}

