/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.lang.reflect.field;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import org.miaixz.bus.core.convert.Converter;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.lang.reflect.Invoker;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.ClassKit;
import org.miaixz.bus.core.xyz.ReflectKit;

public class FieldInvoker
implements Invoker {
    private final Field field;
    private Converter converter;

    public FieldInvoker(Field field) {
        this.field = Assert.notNull(field);
    }

    public static FieldInvoker of(Field field) {
        return null == field ? null : new FieldInvoker(field);
    }

    public Field getField() {
        return this.field;
    }

    @Override
    public String getName() {
        return this.field.getName();
    }

    @Override
    public Type getType() {
        return this.field.getGenericType();
    }

    @Override
    public Class<?> getTypeClass() {
        return this.field.getType();
    }

    public FieldInvoker setConverter(Converter converter) {
        this.converter = converter;
        return this;
    }

    @Override
    public <T> T invoke(Object target, Object ... args) {
        if (ArrayKit.isEmpty(args)) {
            return (T)this.invokeGet(target);
        }
        if (args.length == 1) {
            this.invokeSet(target, args[0]);
            return null;
        }
        throw new InternalException("Field [{}] cannot be set with [{}] args", this.field.getName(), args.length);
    }

    public Object invokeGet(Object object) throws InternalException {
        Object result;
        if (null == this.field) {
            return null;
        }
        if (object instanceof Class) {
            object = null;
        }
        ReflectKit.setAccessible(this.field);
        try {
            result = this.field.get(object);
        }
        catch (IllegalAccessException e) {
            throw new InternalException(e, "IllegalAccess for {}.{}", this.field.getDeclaringClass(), this.field.getName());
        }
        return result;
    }

    public void invokeSet(Object object, Object value) throws InternalException {
        ReflectKit.setAccessible(this.field);
        try {
            this.field.set(object instanceof Class ? null : object, this.convertValue(value));
        }
        catch (IllegalAccessException e) {
            throw new InternalException(e, "IllegalAccess for [{}.{}]", null == object ? this.field.getDeclaringClass() : object, this.field.getName());
        }
    }

    private Object convertValue(Object value) {
        if (null == this.converter) {
            return value;
        }
        Class<?> fieldType = this.field.getType();
        if (null != value) {
            Object targetValue;
            if (!fieldType.isAssignableFrom(value.getClass()) && null != (targetValue = this.converter.convert(fieldType, value))) {
                return targetValue;
            }
        } else {
            return ClassKit.getDefaultValue(fieldType);
        }
        return value;
    }
}

