/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.lang.reflect.field;

import java.lang.reflect.Field;
import java.util.function.Predicate;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.xyz.ArrayKit;

public class FieldReflect {
    private final Class<?> clazz;
    private volatile Field[] declaredFields;
    private volatile Field[] allFields;

    public FieldReflect(Class<?> clazz) {
        this.clazz = Assert.notNull(clazz);
    }

    public static FieldReflect of(Class<?> clazz) {
        return new FieldReflect(clazz);
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public synchronized void clearCaches() {
        this.declaredFields = null;
        this.allFields = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Field[] getDeclaredFields(Predicate<Field> predicate) {
        if (null != this.declaredFields) return ArrayKit.filter(this.declaredFields, predicate);
        Class<FieldReflect> clazz = FieldReflect.class;
        synchronized (FieldReflect.class) {
            if (null != this.declaredFields) return ArrayKit.filter(this.declaredFields, predicate);
            this.declaredFields = this.clazz.getDeclaredFields();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return ArrayKit.filter(this.declaredFields, predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Field[] getAllFields(Predicate<Field> predicate) {
        if (null != this.allFields) return ArrayKit.filter(this.allFields, predicate);
        Class<FieldReflect> clazz = FieldReflect.class;
        synchronized (FieldReflect.class) {
            if (null != this.allFields) return ArrayKit.filter(this.allFields, predicate);
            this.allFields = this.getFieldsDirectly(true);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return ArrayKit.filter(this.allFields, predicate);
        }
    }

    public Field[] getFieldsDirectly(boolean withSuperClassFields) throws SecurityException {
        Field[] allFields = null;
        Class<?> searchType = this.clazz;
        while (searchType != null) {
            Field[] declaredFields = searchType.getDeclaredFields();
            allFields = null == allFields ? declaredFields : ArrayKit.append(allFields, declaredFields);
            searchType = withSuperClassFields ? searchType.getSuperclass() : null;
        }
        return allFields;
    }
}

