/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.lang.reflect.lookup;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.lang.reflect.lookup.LookupFactory;

public class MethodLookupFactory
implements LookupFactory {
    private final Method privateLookupInMethod = MethodLookupFactory.createJdk9PrivateLookupInMethod();

    private static Method createJdk9PrivateLookupInMethod() {
        try {
            return MethodHandles.class.getMethod("privateLookupIn", Class.class, MethodHandles.Lookup.class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("There is no 'privateLookupIn(Class, Lookup)' method in java.lang.invoke.MethodHandles.", e);
        }
    }

    @Override
    public MethodHandles.Lookup lookup(Class<?> callerClass) {
        try {
            return (MethodHandles.Lookup)this.privateLookupInMethod.invoke(MethodHandles.class, callerClass, MethodHandles.lookup());
        }
        catch (IllegalAccessException e) {
            throw new InternalException(e);
        }
        catch (InvocationTargetException e) {
            throw new InternalException(e.getTargetException());
        }
    }
}

